/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockWood;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BooleanBlockProperty;
import cn.nukkit.blockproperty.CommonBlockProperties;
import cn.nukkit.blockproperty.value.WoodType;
import javax.annotation.Nonnull;

public class BlockWoodBark
extends BlockWood {
    private static final String STRIPPED_BIT = "stripped_bit";
    public static final BlockProperties PROPERTIES = new BlockProperties(WoodType.PROPERTY, new BooleanBlockProperty("stripped_bit", true), CommonBlockProperties.PILLAR_AXIS);

    public BlockWoodBark() {
        this(0);
    }

    public BlockWoodBark(int meta) {
        super(meta);
    }

    @Override
    public int getId() {
        return 467;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockProperties getProperties() {
        return PROPERTIES;
    }

    @Override
    public String getName() {
        return (this.isStripped() ? "Stripped " : "") + super.getName();
    }

    @Override
    public WoodType getWoodType() {
        return this.getPropertyValue(WoodType.PROPERTY);
    }

    @Override
    public void setWoodType(WoodType woodType) {
        this.setPropertyValue(WoodType.PROPERTY, woodType);
    }

    public boolean isStripped() {
        return this.getBooleanValue(STRIPPED_BIT);
    }

    public void setStripped(boolean stripped) {
        this.setBooleanValue(STRIPPED_BIT, stripped);
    }
}

