/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import java.util.ArrayList;
import java.util.List;

public class BlockEntityBell
extends BlockEntitySpawnable {
    private boolean ringing;
    private int direction;
    private int ticks;
    public final List<Player> spawnExceptions = new ArrayList<Player>(2);

    public BlockEntityBell(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.ringing = !this.namedTag.contains("Ringing") || !(this.namedTag.get("Ringing") instanceof ByteTag) ? false : this.namedTag.getBoolean("Ringing");
        this.direction = !this.namedTag.contains("Direction") || !(this.namedTag.get("Direction") instanceof IntTag) ? 255 : this.namedTag.getInt("Direction");
        this.ticks = !this.namedTag.contains("Ticks") || !(this.namedTag.get("Ticks") instanceof IntTag) ? 0 : this.namedTag.getInt("Ticks");
        super.initBlockEntity();
        this.scheduleUpdate();
    }

    @Override
    public void saveNBT() {
        this.namedTag.putBoolean("Ringing", this.ringing);
        this.namedTag.putInt("Direction", this.direction);
        this.namedTag.putInt("Ticks", this.ticks);
        super.saveNBT();
    }

    @Override
    public boolean onUpdate() {
        if (this.ringing) {
            if (this.ticks == 0) {
                this.level.addSound(this, Sound.BLOCK_BELL_HIT);
                this.spawnToAllWithExceptions();
                this.spawnExceptions.clear();
            } else if (this.ticks >= 50) {
                this.ringing = false;
                this.ticks = 0;
                this.spawnToAllWithExceptions();
                this.spawnExceptions.clear();
                return false;
            }
            ++this.ticks;
            return true;
        }
        if (this.ticks > 0) {
            this.ticks = 0;
            this.spawnToAllWithExceptions();
            this.spawnExceptions.clear();
        }
        return false;
    }

    private void spawnToAllWithExceptions() {
        if (this.closed) {
            return;
        }
        for (Player player : this.getLevel().getChunkPlayers(this.chunk.getX(), this.chunk.getZ()).values()) {
            if (!player.spawned || this.spawnExceptions.contains(player)) continue;
            this.spawnTo(player);
        }
    }

    public boolean isRinging() {
        return this.ringing;
    }

    public void setRinging(boolean ringing) {
        if (this.level != null && this.ringing != ringing) {
            this.ringing = ringing;
            this.scheduleUpdate();
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag tag = new CompoundTag().putString("id", "Bell").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putBoolean("Ringing", this.ringing).putInt("Direction", this.direction).putInt("Ticks", this.ticks);
        return tag;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 461;
    }
}

