/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.mob.EntityMob;
import cn.nukkit.event.block.ConduitActivateEvent;
import cn.nukkit.event.block.ConduitDeactivateEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.Sound;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.biome.type.SnowyBiome;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector2;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.potion.Effect;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class BlockEntityConduit
extends BlockEntitySpawnable {
    public static IntSet VALID_STRUCTURE_BLOCKS = new IntOpenHashSet(new int[]{168, 169});
    private Entity targetEntity;
    private long target;
    private boolean active;
    private int validBlocks;

    public BlockEntityConduit(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.validBlocks = -1;
        if (!this.namedTag.contains("Target")) {
            this.namedTag.putLong("Target", -1L);
            this.target = -1L;
            this.targetEntity = null;
        } else {
            this.target = this.namedTag.getLong("Target");
        }
        this.active = this.namedTag.getBoolean("Active");
        super.initBlockEntity();
        this.scheduleUpdate();
    }

    @Override
    public void saveNBT() {
        Entity targetEntity = this.targetEntity;
        this.namedTag.putLong("Target", targetEntity != null ? targetEntity.getId() : -1L);
        this.namedTag.putBoolean("Active", this.active);
        super.saveNBT();
    }

    @Override
    public String getName() {
        return "Conduit";
    }

    @Override
    public boolean onUpdate() {
        if (this.closed) {
            return false;
        }
        boolean activeBeforeUpdate = this.active;
        Entity targetBeforeUpdate = this.targetEntity;
        if (this.validBlocks == -1) {
            this.active = this.scanStructure();
        }
        if (this.level.getCurrentTick() % 20L == 0L) {
            this.active = this.scanStructure();
        }
        if (this.target != -1L) {
            this.targetEntity = this.getLevel().getEntity(this.target);
            this.target = -1L;
        }
        if (activeBeforeUpdate != this.active || targetBeforeUpdate != this.targetEntity) {
            this.spawnToAll();
            if (activeBeforeUpdate && !this.active) {
                this.level.addSound(this.add(0.0, 0.5, 0.0), Sound.CONDUIT_DEACTIVATE);
                this.level.getServer().getPluginManager().callEvent(new ConduitDeactivateEvent(this.getBlock()));
            } else if (!activeBeforeUpdate && this.active) {
                this.level.addSound(this.add(0.0, 0.5, 0.0), Sound.CONDUIT_ACTIVATE);
                this.level.getServer().getPluginManager().callEvent(new ConduitActivateEvent(this.getBlock()));
            }
        }
        if (!this.active) {
            this.targetEntity = null;
            this.target = -1L;
        } else if (this.level.getCurrentTick() % 40L == 0L) {
            this.attackMob();
            this.addEffectToPlayers();
        }
        return true;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 412;
    }

    public void setTargetEntity(Entity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public boolean isActive() {
        return this.active;
    }

    public void addEffectToPlayers() {
        int radius = this.getPlayerRadius();
        if (radius <= 0) {
            return;
        }
        int radiusSquared = radius * radius;
        Vector2 conduitPos = new Vector2(this.x, this.z);
        this.getLevel().getPlayers().values().stream().filter(this::canAffect).filter(p -> conduitPos.distanceSquared(p.x, p.z) <= (double)radiusSquared).forEach(p -> p.addEffect(Effect.getEffect(26).setDuration(260).setVisible(true).setAmplifier(0).setAmbient(true)));
    }

    public void attackMob() {
        int radius = this.getAttackRadius();
        if (radius <= 0) {
            return;
        }
        boolean updated = false;
        Entity target = this.targetEntity;
        if (target != null && !this.canAttack(target)) {
            target = null;
            updated = true;
            this.targetEntity = null;
            this.target = -1L;
        }
        if (target == null) {
            Entity[] mobs = (Entity[])Arrays.stream(this.level.getCollidingEntities(new SimpleAxisAlignedBB(this.x - (double)radius, this.y - (double)radius, this.z - (double)radius, this.x + 1.0 + (double)radius, this.y + 1.0 + (double)radius, this.z + 1.0 + (double)radius))).filter(this::canAttack).toArray(Entity[]::new);
            if (mobs.length == 0) {
                if (updated) {
                    this.spawnToAll();
                }
                return;
            }
            this.targetEntity = target = mobs[ThreadLocalRandom.current().nextInt(mobs.length)];
            updated = true;
        }
        if (!target.attack(new EntityDamageByBlockEvent(this.getBlock(), target, EntityDamageEvent.DamageCause.MAGIC, 4.0f))) {
            this.targetEntity = null;
            updated = true;
        }
        if (updated) {
            this.spawnToAll();
        }
    }

    public boolean canAttack(Entity target) {
        return target instanceof EntityMob && this.canAffect(target);
    }

    public boolean canAffect(Entity target) {
        return target.isTouchingWater() || target.level.isRaining() && target.level.canBlockSeeSky(target) && !(Biome.getBiome(target.level.getBiomeId(target.getFloorX(), target.getFloorZ())) instanceof SnowyBiome);
    }

    private boolean scanWater() {
        int x = this.getFloorX();
        int y = this.getFloorY();
        int z = this.getFloorZ();
        for (int ix = -1; ix <= 1; ++ix) {
            for (int iz = -1; iz <= 1; ++iz) {
                for (int iy = -1; iy <= 1; ++iy) {
                    int blockId = this.getLevel().getBlockIdAt(x + ix, y + iy, z + iz, 0);
                    if (blockId == 8 || blockId == 9 || (blockId = this.getLevel().getBlockIdAt(x + ix, y + iy, z + iz, 1)) == 8 || blockId == 9) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int scanFrame() {
        int validBlocks = 0;
        int x = this.getFloorX();
        int y = this.getFloorY();
        int z = this.getFloorZ();
        for (int iy = -2; iy <= 2; ++iy) {
            int blockId;
            int iz;
            if (iy == 0) {
                for (int ix = -2; ix <= 2; ++ix) {
                    for (iz = -2; iz <= 2; ++iz) {
                        if (Math.abs(iz) != 2 && Math.abs(ix) != 2 || !VALID_STRUCTURE_BLOCKS.contains(blockId = this.level.getBlockIdAt(x + ix, y, z + iz))) continue;
                        ++validBlocks;
                    }
                }
                continue;
            }
            int absIY = Math.abs(iy);
            for (int ix = -2; ix <= 2; ++ix) {
                if (absIY != 2 && ix == 0 || absIY != 2 && Math.abs(ix) != 2 || !VALID_STRUCTURE_BLOCKS.contains(blockId = this.level.getBlockIdAt(x + ix, y + iy, z))) continue;
                ++validBlocks;
            }
            for (iz = -2; iz <= 2; ++iz) {
                if (absIY != 2 && iz == 0 || (absIY != 2 || iz == 0) && Math.abs(iz) != 2 || !VALID_STRUCTURE_BLOCKS.contains(blockId = this.level.getBlockIdAt(x, y + iy, z + iz))) continue;
                ++validBlocks;
            }
        }
        return validBlocks;
    }

    public List<Block> scanEdgeBlock() {
        ArrayList<Block> validBlocks = new ArrayList<Block>();
        int x = this.getFloorX();
        int y = this.getFloorY();
        int z = this.getFloorZ();
        for (int iy = -2; iy <= 2; ++iy) {
            if (iy == 0) continue;
            for (int ix = -2; ix <= 2; ++ix) {
                for (int iz = -2; iz <= 2; ++iz) {
                    Block block;
                    if (Math.abs(iy) != 2 && Math.abs(iz) < 2 && Math.abs(ix) < 2 || ix == 0 || iz == 0 || !VALID_STRUCTURE_BLOCKS.contains((block = this.level.getBlock(x + ix, y + iy, z + iz)).getId())) continue;
                    validBlocks.add(block);
                }
            }
        }
        return validBlocks;
    }

    public boolean scanStructure() {
        if (!this.scanWater()) {
            this.validBlocks = 0;
            return false;
        }
        int validBlocks = this.scanFrame();
        if (validBlocks < 16) {
            this.validBlocks = 0;
            return false;
        }
        this.validBlocks = validBlocks;
        return true;
    }

    public int getValidBlocks() {
        return this.validBlocks;
    }

    public int getPlayerRadius() {
        int radius = this.validBlocks / 7;
        return radius * 16;
    }

    public int getAttackRadius() {
        if (this.validBlocks >= 42) {
            return 8;
        }
        return 0;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag tag = new CompoundTag().putString("id", "Conduit").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putBoolean("Active", this.active).putBoolean("isMovable", this.isMovable());
        Entity targetEntity = this.targetEntity;
        tag.putLong("Target", targetEntity != null ? targetEntity.getId() : -1L);
        return tag;
    }
}

