/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.positiontracking.PositionTracking;
import cn.nukkit.positiontracking.PositionTrackingService;
import cn.nukkit.utils.MainLogger;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.util.OptionalInt;
import javax.annotation.Nonnull;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class BlockEntityLodestone
extends BlockEntitySpawnable {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockEntityLodestone(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (this.namedTag.containsInt("trackingHandler")) {
            this.namedTag.put("trackingHandle", (Tag)this.namedTag.removeAndGet("trackingHandler"));
        }
        super.initBlockEntity();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public OptionalInt getTrackingHandler() {
        if (this.namedTag.containsInt("trackingHandle")) {
            return OptionalInt.of(this.namedTag.getInt("trackingHandle"));
        }
        return OptionalInt.empty();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int requestTrackingHandler() throws IOException {
        int handler;
        PositionTracking position;
        OptionalInt opt = this.getTrackingHandler();
        PositionTrackingService positionTrackingService = this.getLevel().getServer().getPositionTrackingService();
        Position floor = this.floor();
        if (opt.isPresent() && (position = positionTrackingService.getPosition(handler = opt.getAsInt())) != null && position.matchesNamedPosition(floor)) {
            return handler;
        }
        handler = positionTrackingService.addOrReusePosition(floor);
        this.namedTag.putInt("trackingHandle", handler);
        return handler;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getLevelBlock().getId() == 477;
    }

    @Override
    public void onBreak() {
        IntList handlers;
        PositionTrackingService positionTrackingService = Server.getInstance().getPositionTrackingService();
        try {
            handlers = positionTrackingService.findTrackingHandlers(this);
            if (handlers.isEmpty()) {
                return;
            }
        }
        catch (IOException e) {
            MainLogger.getLogger().error("Failed to remove the tracking position handler for " + this.getLocation());
            return;
        }
        int size = handlers.size();
        for (int i = 0; i < size; ++i) {
            int handler = handlers.getInt(i);
            try {
                positionTrackingService.invalidateHandler(handler);
                continue;
            }
            catch (IOException e) {
                MainLogger.getLogger().error("Failed to remove the tracking handler " + handler + " for position " + this.getLocation(), e);
            }
        }
    }
}

