/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.tag.CompoundTag;

public class BlockEntitySkull
extends BlockEntitySpawnable {
    private boolean mouthMoving;
    private int mouthTickCount;

    public BlockEntitySkull(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!this.namedTag.contains("SkullType")) {
            this.namedTag.putByte("SkullType", 0);
        }
        if (!this.namedTag.contains("Rot")) {
            this.namedTag.putByte("Rot", 0);
        }
        if (this.namedTag.containsByte("MouthMoving")) {
            this.mouthMoving = this.namedTag.getBoolean("MouthMoving");
        }
        if (this.namedTag.containsInt("MouthTickCount")) {
            this.mouthTickCount = NukkitMath.clamp(this.namedTag.getInt("MouthTickCount"), 0, 60);
        }
        super.initBlockEntity();
    }

    @Override
    public boolean onUpdate() {
        if (this.isMouthMoving()) {
            ++this.mouthTickCount;
            this.setDirty();
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setMouthMoving(boolean mouthMoving) {
        if (this.mouthMoving == mouthMoving) {
            return;
        }
        this.mouthMoving = mouthMoving;
        if (mouthMoving) {
            this.scheduleUpdate();
        }
        this.level.updateComparatorOutputLevelSelective(this, true);
        this.spawnToAll();
        if (this.chunk != null) {
            this.setDirty();
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isObservable() {
        return false;
    }

    @Override
    public void setDirty() {
        this.chunk.setChanged();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isMouthMoving() {
        return this.mouthMoving;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getMouthTickCount() {
        return this.mouthTickCount;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setMouthTickCount(int mouthTickCount) {
        if (this.mouthTickCount == mouthTickCount) {
            return;
        }
        this.mouthTickCount = mouthTickCount;
        this.spawnToAll();
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putBoolean("MouthMoving", this.mouthMoving).putInt("MouthTickCount", this.mouthTickCount).remove("Creator");
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getBlock().getId() == 144;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return new CompoundTag().putString("id", "Skull").put("SkullType", this.namedTag.get("SkullType")).putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).put("Rot", this.namedTag.get("Rot")).putBoolean("MouthMoving", this.mouthMoving).putInt("MouthTickCount", this.mouthTickCount);
    }
}

