/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.math.NukkitMath;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class ArrayBlockProperty<E extends Serializable>
extends BlockProperty<E> {
    private static final long serialVersionUID = 507174531989068430L;
    @Nonnull
    private final E[] universe;
    private final String[] persistenceNames;
    private final Class<E> eClass;
    private final boolean ordinal;

    private static <E> E[] checkUniverseLength(E[] universe) {
        Preconditions.checkNotNull(universe, "universe can't be null");
        Preconditions.checkArgument(universe.length > 0, "The universe can't be empty");
        return universe;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ArrayBlockProperty(String name, boolean exportedToItem, E[] universe, int bitSize, String persistenceName) {
        this(name, exportedToItem, (Serializable[])universe, bitSize, persistenceName, false);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ArrayBlockProperty(String name, boolean exportedToItem, E[] universe, int bitSize, String persistenceName, boolean ordinal) {
        this(name, exportedToItem, (Serializable[])universe, bitSize, persistenceName, ordinal, ordinal ? null : (String[])Arrays.stream(universe).map(Objects::toString).map(String::toLowerCase).toArray(String[]::new));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ArrayBlockProperty(String name, boolean exportedToItem, E[] universe, int bitSize, String persistenceName, boolean ordinal, @Nullable String[] persistenceNames) {
        super(name, exportedToItem, bitSize, persistenceName);
        ArrayBlockProperty.checkUniverseLength(universe);
        if (!ordinal) {
            Preconditions.checkArgument(persistenceNames != null, "persistenceNames can't be null when ordinal is false");
            Preconditions.checkArgument(persistenceNames.length == universe.length, "persistenceNames and universe must have the same length when ordinal is false");
            this.persistenceNames = (String[])persistenceNames.clone();
        } else {
            this.persistenceNames = null;
        }
        this.ordinal = ordinal;
        this.universe = (Serializable[])universe.clone();
        this.eClass = universe.getClass().getComponentType();
        HashSet<E> elements = new HashSet<E>();
        HashSet<String> persistenceNamesCheck = new HashSet<String>();
        for (int i = 0; i < this.universe.length; ++i) {
            E element = this.universe[i];
            Preconditions.checkNotNull(element, "The universe can not contain null values");
            Preconditions.checkArgument(elements.add(element), "The universe can not have duplicated elements");
            if (ordinal) continue;
            String elementName = this.persistenceNames[i];
            Preconditions.checkNotNull(elementName, "The persistenceNames can not contain null values");
            Preconditions.checkArgument(persistenceNamesCheck.add(elementName), "The persistenceNames can not have duplicated elements");
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ArrayBlockProperty(String name, boolean exportedToItem, E[] universe, int bitSize) {
        this(name, exportedToItem, (Serializable[])universe, bitSize, name);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ArrayBlockProperty(String name, boolean exportedToItem, E[] universe) {
        this(name, exportedToItem, (Serializable[])ArrayBlockProperty.checkUniverseLength(universe), NukkitMath.bitLength(universe.length - 1));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ArrayBlockProperty(String name, boolean exportedToItem, Class<E> enumClass) {
        this(name, exportedToItem, (Serializable[])enumClass.getEnumConstants());
    }

    public ArrayBlockProperty<E> ordinal(boolean ordinal) {
        if (ordinal == this.ordinal) {
            return this;
        }
        return new ArrayBlockProperty(this.getName(), this.isExportedToItem(), this.universe, this.getBitSize(), this.getPersistenceName(), ordinal);
    }

    @Override
    public int getMetaForValue(@Nullable E value) {
        if (value == null) {
            return 0;
        }
        for (int i = 0; i < this.universe.length; ++i) {
            if (!this.universe[i].equals(value)) continue;
            return i;
        }
        throw new InvalidBlockPropertyValueException((BlockProperty<?>)this, null, (Serializable)value, "Element is not part of this property");
    }

    @Override
    @Nonnull
    public E getValueForMeta(int meta) {
        return this.universe[meta];
    }

    @Override
    public int getIntValueForMeta(int meta) {
        try {
            this.validateMetaDirectly(meta);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, e);
        }
        return meta;
    }

    @Override
    @Nonnull
    public String getPersistenceValueForMeta(int meta) {
        try {
            this.validateMetaDirectly(meta);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, e);
        }
        if (this.isOrdinal()) {
            return Integer.toString(meta);
        }
        return this.persistenceNames[meta];
    }

    @Override
    protected void validateDirectly(@Nullable E value) {
        for (E object : this.universe) {
            if (object != value) continue;
            return;
        }
        throw new IllegalArgumentException(value + " is not valid for this property");
    }

    @Override
    protected void validateMetaDirectly(int meta) {
        Preconditions.checkElementIndex(meta, this.universe.length);
    }

    @Override
    @Nonnull
    public Class<E> getValueClass() {
        return this.eClass;
    }

    @Nonnull
    public E[] getUniverse() {
        return (Serializable[])this.universe.clone();
    }

    public boolean isOrdinal() {
        return this.ordinal;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public E getDefaultValue() {
        return this.universe[0];
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultValue(@Nullable E value) {
        return value == null || this.universe[0].equals(value);
    }
}

