/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public abstract class BlockProperty<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -2594821043880025191L;
    private final int bitSize;
    private final String name;
    private final String persistenceName;
    private final boolean exportedToItem;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockProperty(String name, boolean exportedToItem, int bitSize, String persistenceName) {
        Preconditions.checkArgument(bitSize > 0, "Bit size (%s) must be positive", bitSize);
        this.bitSize = bitSize;
        this.name = name;
        this.persistenceName = persistenceName;
        this.exportedToItem = exportedToItem;
    }

    private int computeRightMask(int bitOffset) {
        return bitOffset == 0 ? 0 : -1 >>> 32 - bitOffset;
    }

    private long computeBigRightMask(int bitOffset) {
        return (long)bitOffset == 0L ? 0L : -1L >>> 64 - bitOffset;
    }

    private BigInteger computeHugeRightMask(int bitOffset) {
        return BigInteger.ONE.shiftLeft(bitOffset).subtract(BigInteger.ONE);
    }

    private int computeValueMask(int bitOffset) {
        Preconditions.checkArgument(bitOffset >= 0, "Bit offset can not be negative. Got %s", bitOffset);
        int maskBits = this.bitSize + bitOffset;
        Preconditions.checkArgument(0 < maskBits && maskBits <= 32, "The bit offset %s plus the bit size %s causes memory overflow (32 bits)", bitOffset, this.bitSize);
        int rightMask = this.computeRightMask(bitOffset);
        int leftMask = -1 << maskBits;
        return ~rightMask & ~leftMask;
    }

    private long computeBigValueMask(int bitOffset) {
        Preconditions.checkArgument(bitOffset >= 0, "Bit offset can not be negative. Got %s", bitOffset);
        int maskBits = this.bitSize + bitOffset;
        Preconditions.checkArgument(0 < maskBits && maskBits <= 64, "The bit offset %s plus the bit size %s causes memory overflow (64 bits)", bitOffset, this.bitSize);
        long rightMask = this.computeBigRightMask(bitOffset);
        long leftMask = -1L << maskBits;
        return (rightMask ^ 0xFFFFFFFFFFFFFFFFL) & (leftMask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private BigInteger computeHugeValueMask(int bitOffset) {
        Preconditions.checkArgument(bitOffset >= 0, "Bit offset can not be negative. Got %s", bitOffset);
        int maskBits = this.bitSize + bitOffset;
        Preconditions.checkArgument(0 < maskBits, "The bit offset %s plus the bit size %s causes memory overflow (huge)", bitOffset, this.bitSize);
        BigInteger rightMask = this.computeHugeRightMask(bitOffset);
        BigInteger leftMask = BigInteger.valueOf(-1L).shiftLeft(maskBits);
        return rightMask.not().andNot(leftMask);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int setValue(int currentMeta, int bitOffset, @Nullable T newValue) {
        int mask = this.computeValueMask(bitOffset);
        try {
            int value = this.getMetaForValue(newValue) << bitOffset;
            if ((value & ~mask) != 0) {
                throw new IllegalStateException("Attempted to set a value which overflows the size of " + this.bitSize + " bits. Current:" + currentMeta + ", offset:" + bitOffset + ", meta:" + value + ", value:" + newValue);
            }
            return currentMeta & ~mask | value & mask;
        }
        catch (Exception e) {
            Serializable oldValue = null;
            InvalidBlockPropertyMetaException suppressed = null;
            try {
                oldValue = (Serializable)this.getValue(currentMeta, bitOffset);
            }
            catch (Exception e2) {
                suppressed = new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & mask), e2);
            }
            InvalidBlockPropertyValueException toThrow = new InvalidBlockPropertyValueException((BlockProperty<?>)this, oldValue, (Serializable)newValue, e);
            if (suppressed != null) {
                toThrow.addSuppressed(suppressed);
            }
            throw toThrow;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long setValue(long currentBigMeta, int bitOffset, @Nullable T newValue) {
        long mask = this.computeBigValueMask(bitOffset);
        try {
            long value = this.getMetaForValue(newValue) << bitOffset;
            if ((value & (mask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
                throw new IllegalStateException("Attempted to set a value which overflows the size of " + this.bitSize + " bits. Current:" + currentBigMeta + ", offset:" + bitOffset + ", meta:" + value + ", value:" + newValue);
            }
            return currentBigMeta & (mask ^ 0xFFFFFFFFFFFFFFFFL) | value & mask;
        }
        catch (Exception e) {
            Serializable oldValue = null;
            InvalidBlockPropertyMetaException suppressed = null;
            try {
                oldValue = (Serializable)this.getValue(currentBigMeta, bitOffset);
            }
            catch (Exception e2) {
                suppressed = new InvalidBlockPropertyMetaException(this, (Number)currentBigMeta, (Number)(currentBigMeta & mask), e2);
            }
            InvalidBlockPropertyValueException toThrow = new InvalidBlockPropertyValueException((BlockProperty<?>)this, oldValue, (Serializable)newValue, e);
            if (suppressed != null) {
                toThrow.addSuppressed(suppressed);
            }
            throw toThrow;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger setValue(BigInteger currentHugeMeta, int bitOffset, @Nullable T newValue) {
        BigInteger mask = this.computeHugeValueMask(bitOffset);
        try {
            BigInteger value = BigInteger.valueOf(this.getMetaForValue(newValue)).shiftLeft(bitOffset);
            if (!value.andNot(mask).equals(BigInteger.ZERO)) {
                throw new IllegalStateException("Attempted to set a value which overflows the size of " + this.bitSize + " bits. Current:" + currentHugeMeta + ", offset:" + bitOffset + ", meta:" + value + ", value:" + newValue);
            }
            return currentHugeMeta.andNot(mask).or(value.and(mask));
        }
        catch (Exception e) {
            Serializable oldValue = null;
            InvalidBlockPropertyMetaException suppressed = null;
            try {
                oldValue = (Serializable)this.getValue(currentHugeMeta, bitOffset);
            }
            catch (Exception e2) {
                suppressed = new InvalidBlockPropertyMetaException(this, (Number)currentHugeMeta, (Number)currentHugeMeta.and(mask), e2);
            }
            InvalidBlockPropertyValueException toThrow = new InvalidBlockPropertyValueException((BlockProperty<?>)this, oldValue, (Serializable)newValue, e);
            if (suppressed != null) {
                toThrow.addSuppressed(suppressed);
            }
            throw toThrow;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final int getMetaFromInt(int currentMeta, int bitOffset) {
        return (currentMeta & this.computeValueMask(bitOffset)) >>> bitOffset;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final int getMetaFromLong(long currentMeta, int bitOffset) {
        return (int)((currentMeta & this.computeBigValueMask(bitOffset)) >>> bitOffset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final int getMetaFromBigInt(BigInteger currentMeta, int bitOffset) {
        return currentMeta.and(this.computeHugeValueMask(bitOffset)).shiftRight(bitOffset).intValue();
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public T getValue(int currentMeta, int bitOffset) {
        int meta = this.getMetaFromInt(currentMeta, bitOffset);
        try {
            return this.getValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeValueMask(bitOffset)), e);
        }
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public T getValue(long currentBigMeta, int bitOffset) {
        int meta = this.getMetaFromLong(currentBigMeta, bitOffset);
        try {
            return this.getValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentBigMeta, (Number)(currentBigMeta & this.computeBigValueMask(bitOffset)), e);
        }
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public T getValue(BigInteger currentHugeMeta, int bitOffset) {
        int meta = this.getMetaFromBigInt(currentHugeMeta, bitOffset);
        try {
            return this.getValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentHugeMeta, (Number)currentHugeMeta.and(this.computeHugeValueMask(bitOffset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(int currentMeta, int bitOffset) {
        int meta = this.getMetaFromInt(currentMeta, bitOffset);
        try {
            return this.getIntValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeValueMask(bitOffset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(long currentMeta, int bitOffset) {
        int meta = this.getMetaFromLong(currentMeta, bitOffset);
        try {
            return this.getIntValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeBigValueMask(bitOffset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getIntValue(BigInteger currentMeta, int bitOffset) {
        int meta = this.getMetaFromBigInt(currentMeta, bitOffset);
        try {
            return this.getIntValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)currentMeta.and(this.computeHugeValueMask(bitOffset)), e);
        }
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getPersistenceValue(int currentMeta, int bitOffset) {
        int meta = this.getMetaFromInt(currentMeta, bitOffset);
        try {
            return this.getPersistenceValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeValueMask(bitOffset)), e);
        }
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getPersistenceValue(long currentMeta, int bitOffset) {
        int meta = this.getMetaFromLong(currentMeta, bitOffset);
        try {
            return this.getPersistenceValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)(currentMeta & this.computeBigValueMask(bitOffset)), e);
        }
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getPersistenceValue(BigInteger currentMeta, int bitOffset) {
        int meta = this.getMetaFromBigInt(currentMeta, bitOffset);
        try {
            return this.getPersistenceValueForMeta(meta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)currentMeta, (Number)currentMeta.and(this.computeHugeValueMask(bitOffset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract int getMetaForValue(@Nullable T var1);

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract T getValueForMeta(int var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract int getIntValueForMeta(int var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract String getPersistenceValueForMeta(int var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected void validateDirectly(@Nullable T value) {
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected abstract void validateMetaDirectly(int var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final void validateMeta(int meta, int offset) {
        int propMeta = this.getMetaFromInt(meta, offset);
        try {
            this.validateMetaDirectly(propMeta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)(meta & this.computeValueMask(offset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final void validateMeta(long meta, int offset) {
        int propMeta = this.getMetaFromLong(meta, offset);
        try {
            this.validateMetaDirectly(propMeta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)(meta & this.computeBigValueMask(offset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public final void validateMeta(BigInteger meta, int offset) {
        int propMeta = this.getMetaFromBigInt(meta, offset);
        try {
            this.validateMetaDirectly(propMeta);
        }
        catch (Exception e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta.and(this.computeHugeRightMask(offset)), e);
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getBitSize() {
        return this.bitSize;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getName() {
        return this.name;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public String getPersistenceName() {
        return this.persistenceName;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract Class<T> getValueClass();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isExportedToItem() {
        return this.exportedToItem;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + ", bitSize=" + this.bitSize + ", exportedToItem=" + this.exportedToItem + ", persistenceName='" + this.persistenceName + '\'' + '}';
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract boolean isDefaultValue(@Nullable T var1);

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public abstract T getDefaultValue();

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDefaultIntValue(int value) {
        return value == this.getDefaultIntValue();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDefaultBooleanValue(boolean value) {
        return value == this.getDefaultBooleanValue();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getDefaultIntValue() {
        return 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getDefaultBooleanValue() {
        return false;
    }
}

