/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public final class BooleanBlockProperty
extends BlockProperty<Boolean> {
    private static final long serialVersionUID = 8249827149092664486L;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BooleanBlockProperty(String name, boolean exportedToItem, String persistenceName) {
        super(name, exportedToItem, 1, persistenceName);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BooleanBlockProperty(String name, boolean exportedToItem) {
        super(name, exportedToItem, 1, name);
    }

    @Override
    public int setValue(int currentMeta, int bitOffset, @Nullable Boolean newValue) {
        boolean value = newValue != null && newValue != false;
        return this.setValue(currentMeta, bitOffset, value);
    }

    @Override
    public long setValue(long currentBigMeta, int bitOffset, @Nullable Boolean newValue) {
        boolean value = newValue != null && newValue != false;
        return this.setValue(currentBigMeta, bitOffset, value);
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int setValue(int currentMeta, int bitOffset, boolean newValue) {
        int mask = 1 << bitOffset;
        return newValue ? currentMeta | mask : currentMeta & ~mask;
    }

    @Override
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long setValue(long currentMeta, int bitOffset, boolean newValue) {
        long mask = 1L << bitOffset;
        return newValue ? currentMeta | mask : currentMeta & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    @Nonnull
    public Boolean getValue(int currentMeta, int bitOffset) {
        return this.getBooleanValue(currentMeta, bitOffset);
    }

    @Override
    @Nonnull
    public Boolean getValue(long currentBigMeta, int bitOffset) {
        return this.getBooleanValue(currentBigMeta, bitOffset);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(int currentMeta, int bitOffset) {
        int mask = 1 << bitOffset;
        return (currentMeta & mask) == mask;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(long currentBigMeta, int bitOffset) {
        long mask = 1L << bitOffset;
        return (currentBigMeta & mask) == mask;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValue(BigInteger currentHugeData, int bitOffset) {
        BigInteger mask = BigInteger.ONE.shiftLeft(bitOffset);
        return mask.equals(currentHugeData.and(mask));
    }

    @Override
    public int getIntValue(int currentMeta, int bitOffset) {
        return this.getBooleanValue(currentMeta, bitOffset) ? 1 : 0;
    }

    @Override
    public int getIntValueForMeta(int meta) {
        if (meta == 1 || meta == 0) {
            return meta;
        }
        throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, "Only 1 or 0 was expected");
    }

    @Override
    public int getMetaForValue(@Nullable Boolean value) {
        return Boolean.TRUE.equals(value) ? 1 : 0;
    }

    @Override
    @Nonnull
    public Boolean getValueForMeta(int meta) {
        return this.getBooleanValueForMeta(meta);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean getBooleanValueForMeta(int meta) {
        if (meta == 0) {
            return false;
        }
        if (meta == 1) {
            return true;
        }
        throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, "Only 1 or 0 was expected");
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Boolean getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultValue(@Nullable Boolean value) {
        return value == null || Boolean.FALSE.equals(value);
    }

    @Override
    protected void validateMetaDirectly(int meta) {
        Preconditions.checkArgument(meta == 1 || meta == 0, "Must be 1 or 0");
    }

    @Override
    @Nonnull
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public String getPersistenceValueForMeta(int meta) {
        if (meta == 1) {
            return "1";
        }
        if (meta == 0) {
            return "0";
        }
        throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, "Only 1 or 0 was expected");
    }
}

