/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.math.NukkitMath;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class IntBlockProperty
extends BlockProperty<Integer> {
    private static final long serialVersionUID = -2239010977496415152L;
    private final int minValue;
    private final int maxValue;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public IntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize, String persistenceName) {
        super(name, exportedToItem, bitSize, persistenceName);
        int delta = maxValue - minValue;
        Preconditions.checkArgument(delta > 0, "maxValue must be higher than minValue. Got min:%s and max:%s", minValue, maxValue);
        int mask = -1 >>> 32 - bitSize;
        Preconditions.checkArgument(delta <= mask, "The data range from %s to %s can't be stored in %s bits", (Object)minValue, (Object)maxValue, (Object)bitSize);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public IntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize) {
        this(name, exportedToItem, maxValue, minValue, bitSize, name);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public IntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue) {
        this(name, exportedToItem, maxValue, minValue, NukkitMath.bitLength(maxValue - minValue));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public IntBlockProperty(String name, boolean exportedToItem, int maxValue) {
        this(name, exportedToItem, maxValue, 0);
    }

    @Override
    public int getMetaForValue(@Nullable Integer value) {
        if (value == null) {
            return 0;
        }
        try {
            this.validateDirectly(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyValueException(this, null, (Serializable)value, e);
        }
        return value - this.minValue;
    }

    @Override
    @Nonnull
    public Integer getValueForMeta(int meta) {
        return this.getIntValueForMeta(meta);
    }

    @Override
    public int getIntValueForMeta(int meta) {
        try {
            this.validateMetaDirectly(meta);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, e);
        }
        return this.minValue + meta;
    }

    @Override
    public String getPersistenceValueForMeta(int meta) {
        return String.valueOf(this.getIntValueForMeta(meta));
    }

    @Override
    protected void validateDirectly(@Nullable Integer value) {
        if (value == null) {
            return;
        }
        int newValue = value;
        Preconditions.checkArgument(newValue >= this.minValue, "New value (%s) must be higher or equals to %s", newValue, this.minValue);
        Preconditions.checkArgument(this.maxValue >= newValue, "New value (%s) must be less or equals to %s", newValue, this.maxValue);
    }

    @Override
    protected void validateMetaDirectly(int meta) {
        int max = this.maxValue - this.minValue;
        Preconditions.checkArgument(0 <= meta && meta <= max, "The meta %s is outside the range of 0 .. ", meta, max);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getMaxValue() {
        return this.maxValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getMinValue() {
        return this.minValue;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Integer getDefaultValue() {
        return this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultIntValue(int value) {
        return this.minValue == value;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getDefaultIntValue() {
        return this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultValue(@Nullable Integer value) {
        return value == null || this.minValue == value;
    }

    @Override
    @Nonnull
    public Class<Integer> getValueClass() {
        return Integer.class;
    }
}

