/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyValueException;
import cn.nukkit.math.NukkitMath;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class UnsignedIntBlockProperty
extends BlockProperty<Integer> {
    private static final long serialVersionUID = 7896101036099245755L;
    private final long minValue;
    private final long maxValue;

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize, String persistenceName) {
        super(name, exportedToItem, bitSize, persistenceName);
        long unsignedMinValue = UnsignedIntBlockProperty.removeSign(minValue);
        long unsignedMaxValue = UnsignedIntBlockProperty.removeSign(maxValue);
        long delta = unsignedMaxValue - unsignedMinValue;
        Preconditions.checkArgument(delta > 0L, "maxValue must be higher than minValue. Got min:%s and max:%s", unsignedMinValue, unsignedMaxValue);
        long mask = UnsignedIntBlockProperty.removeSign(-1 >>> 32 - bitSize);
        Preconditions.checkArgument(delta <= mask, "The data range from %s to %s can't be stored in %s bits", (Object)unsignedMinValue, (Object)unsignedMaxValue, (Object)bitSize);
        this.minValue = unsignedMinValue;
        this.maxValue = unsignedMaxValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize) {
        this(name, exportedToItem, maxValue, minValue, bitSize, name);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue) {
        this(name, exportedToItem, maxValue, minValue, NukkitMath.bitLength(maxValue - minValue));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public UnsignedIntBlockProperty(String name, boolean exportedToItem, int maxValue) {
        this(name, exportedToItem, maxValue, 0);
    }

    private static long removeSign(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    @Override
    public int getMetaForValue(@Nullable Integer value) {
        if (value == null) {
            return 0;
        }
        long unsigned = UnsignedIntBlockProperty.removeSign(value);
        try {
            this.validateDirectly(unsigned);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyValueException(this, null, (Serializable)value, e);
        }
        return (int)(unsigned - this.minValue);
    }

    @Override
    @Nonnull
    public Integer getValueForMeta(int meta) {
        return this.getIntValueForMeta(meta);
    }

    @Override
    public int getIntValueForMeta(int meta) {
        try {
            this.validateMetaDirectly(meta);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, e);
        }
        return (int)(this.minValue + (long)meta);
    }

    @Override
    public String getPersistenceValueForMeta(int meta) {
        return String.valueOf(this.getIntValueForMeta(meta));
    }

    @Override
    protected void validateDirectly(@Nullable Integer value) {
        if (value == null) {
            return;
        }
        this.validateDirectly(UnsignedIntBlockProperty.removeSign(value));
    }

    @Override
    private void validateDirectly(long unsigned) {
        Preconditions.checkArgument(unsigned >= this.minValue, "New value (%s) must be higher or equals to %s", unsigned, this.minValue);
        Preconditions.checkArgument(this.maxValue >= unsigned, "New value (%s) must be less or equals to %s", unsigned, this.maxValue);
    }

    @Override
    protected void validateMetaDirectly(int meta) {
        long max = this.maxValue - this.minValue;
        Preconditions.checkArgument(0 <= meta && (long)meta <= max, "The meta %s is outside the range of 0 .. ", meta, max);
    }

    @Override
    @Nonnull
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long getMaxValue() {
        return this.maxValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public long getMinValue() {
        return this.minValue;
    }

    @Override
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public Integer getDefaultValue() {
        return (int)this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultValue(@Nullable Integer value) {
        return value == null || UnsignedIntBlockProperty.removeSign(value) == this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultIntValue(int value) {
        return UnsignedIntBlockProperty.removeSign(value) == this.minValue;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getDefaultIntValue() {
        return (int)this.minValue;
    }
}

