/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.exception;

import cn.nukkit.blockproperty.BlockProperty;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public class InvalidBlockPropertyException
extends IllegalArgumentException {
    private static final long serialVersionUID = -6934630506175381230L;
    private final BlockProperty<?> property;

    public InvalidBlockPropertyException(@Nonnull BlockProperty<?> property) {
        super(InvalidBlockPropertyException.buildMessage(property));
        this.property = property;
    }

    public InvalidBlockPropertyException(@Nonnull BlockProperty<?> property, String message) {
        super(InvalidBlockPropertyException.buildMessage(property) + ". " + message);
        this.property = property;
    }

    public InvalidBlockPropertyException(@Nonnull BlockProperty<?> property, String message, Throwable cause) {
        super(InvalidBlockPropertyException.buildMessage(property) + ". " + message, cause);
        this.property = property;
    }

    public InvalidBlockPropertyException(@Nonnull BlockProperty<?> property, Throwable cause) {
        super(InvalidBlockPropertyException.buildMessage(property), cause);
        this.property = property;
    }

    private static String buildMessage(@Nonnull BlockProperty<?> property) {
        return "Property: " + property.getName();
    }

    public BlockProperty<?> getProperty() {
        return this.property;
    }
}

