/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.exception;

import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

@ParametersAreNullableByDefault
public class InvalidBlockPropertyValueException
extends InvalidBlockPropertyException {
    private static final long serialVersionUID = -1087431932428639175L;
    @Nullable
    private final Serializable currentValue;
    @Nullable
    private final Serializable invalidValue;

    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue));
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue, String message) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue) + ". " + message);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue, String message, Throwable cause) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue) + ". " + message, cause);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    public InvalidBlockPropertyValueException(@Nonnull BlockProperty<?> property, Serializable currentValue, Serializable invalidValue, Throwable cause) {
        super(property, InvalidBlockPropertyValueException.buildMessage(currentValue, invalidValue), cause);
        this.currentValue = currentValue;
        this.invalidValue = invalidValue;
    }

    private static String buildMessage(Object currentValue, Object invalidValue) {
        return "Current Value: " + currentValue + ", Invalid Value: " + invalidValue;
    }

    @Nullable
    public Serializable getCurrentValue() {
        return this.currentValue;
    }

    @Nullable
    public Serializable getInvalidValue() {
        return this.invalidValue;
    }
}

