/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockproperty.value;

import cn.nukkit.blockproperty.ArrayBlockProperty;
import cn.nukkit.utils.BlockColor;
import java.io.Serializable;

public enum StoneSlab1Type {
    SMOOTH_STONE("Smooth Stone"),
    SANDSTONE(BlockColor.SAND_BLOCK_COLOR),
    WOOD(BlockColor.WOOD_BLOCK_COLOR),
    COBBLESTONE,
    BRICK,
    STONE_BRICK("Stone Brick"),
    QUARTZ(BlockColor.QUARTZ_BLOCK_COLOR),
    NETHER_BRICK(BlockColor.NETHERRACK_BLOCK_COLOR, "Nether Brick");

    public static final ArrayBlockProperty<StoneSlab1Type> PROPERTY;
    private final BlockColor color;
    private final String englishName;

    private StoneSlab1Type() {
        this(BlockColor.STONE_BLOCK_COLOR);
    }

    private StoneSlab1Type(String name) {
        this.color = BlockColor.STONE_BLOCK_COLOR;
        this.englishName = name;
    }

    private StoneSlab1Type(BlockColor color) {
        this.color = color;
        this.englishName = this.name().substring(0, 1) + this.name().substring(1).toLowerCase();
    }

    private StoneSlab1Type(BlockColor color, String name) {
        this.color = color;
        this.englishName = name;
    }

    public BlockColor getColor() {
        return this.color;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    static {
        PROPERTY = new ArrayBlockProperty("stone_slab_type", true, (Serializable[])StoneSlab1Type.values());
    }
}

