/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.Unsigned;
import cn.nukkit.block.Block;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.IMutableBlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.Validation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class BigIntegerMutableBlockState
extends MutableBlockState {
    private static final Set<Class<?>> LONG_COMPATIBLE_CLASSES = new HashSet<Class>(Arrays.asList(Long.class, Integer.class, Short.class, Byte.class));
    private BigInteger storage;

    public BigIntegerMutableBlockState(int blockId, BlockProperties properties, BigInteger state) {
        super(blockId, properties);
        this.storage = state;
    }

    public BigIntegerMutableBlockState(int blockId, BlockProperties properties) {
        this(blockId, properties, BigInteger.ZERO);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorage(@Nonnegative Number storage) {
        BigInteger state;
        if (storage instanceof BigInteger) {
            state = (BigInteger)storage;
        } else if (LONG_COMPATIBLE_CLASSES.contains(storage.getClass())) {
            state = BigInteger.valueOf(storage.longValue());
        } else {
            try {
                state = new BigDecimal(storage.toString()).toBigIntegerExact();
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw IMutableBlockState.handleUnsupportedStorageType(this.getBlockId(), storage, e);
            }
        }
        this.validate(state);
        this.storage = state;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorageFromInt(@Nonnegative int storage) {
        BigInteger state = BigInteger.valueOf(storage);
        this.validate(state);
        this.storage = state;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    void setDataStorageWithoutValidation(Number storage) {
        this.storage = storage instanceof BigInteger ? (BigInteger)storage : new BigInteger(storage.toString());
    }

    @Override
    public void validate() {
        this.validate(this.storage);
    }

    private void validate(BigInteger state) {
        if (BigInteger.ZERO.equals(state)) {
            return;
        }
        Validation.checkPositive("state", state);
        BlockProperties properties = this.properties;
        int bitLength = NukkitMath.bitLength(state);
        if (bitLength > properties.getBitSize()) {
            throw new InvalidBlockStateException(BlockState.of(this.getBlockId(), state), "The state have more data bits than specified in the properties. Bits: " + bitLength + ", Max: " + properties.getBitSize());
        }
        try {
            for (String name : properties.getNames()) {
                BlockProperty<?> property = properties.getBlockProperty(name);
                property.validateMeta(state, properties.getOffset(name));
            }
        }
        catch (InvalidBlockPropertyException e) {
            throw new InvalidBlockStateException(BlockState.of(this.getBlockId(), state), (Throwable)e);
        }
    }

    @Override
    @Nonnegative
    @Deprecated
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getLegacyDamage() {
        return this.storage.and(BigInteger.valueOf(Block.DATA_MASK)).intValue();
    }

    @Override
    @Deprecated
    @Unsigned
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getBigDamage() {
        return this.storage.and(BigInteger.valueOf(-1L)).intValue();
    }

    @Override
    @Nonnegative
    @Deprecated
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    @DeprecationDetails(reason="Can't store all data, exists for backward compatibility reasons", since="1.4.0.0-PN", replaceWith="getDataStorage()")
    public int getSignedBigDamage() {
        return this.storage.and(BigInteger.valueOf(Integer.MAX_VALUE)).intValue();
    }

    @Override
    @Nonnegative
    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BigInteger getHugeDamage() {
        return this.storage;
    }

    @Override
    @Nonnegative
    @Nonnull
    public Number getDataStorage() {
        return this.getHugeDamage();
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultState() {
        return this.storage.equals(BigInteger.ONE);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setPropertyValue(String propertyName, @Nullable Serializable value) {
        this.storage = this.properties.setValue(this.storage, propertyName, value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBooleanValue(String propertyName, boolean value) {
        this.storage = this.properties.setValue(this.storage, propertyName, (Serializable)Boolean.valueOf(value));
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setIntValue(String propertyName, int value) {
        this.storage = this.properties.setValue(this.storage, propertyName, (Serializable)Integer.valueOf(value));
    }

    @Override
    @Nonnull
    public Serializable getPropertyValue(String propertyName) {
        return this.properties.getValue(this.storage, propertyName);
    }

    @Override
    public int getIntValue(String propertyName) {
        return this.properties.getIntValue(this.storage, propertyName);
    }

    @Override
    public boolean getBooleanValue(String propertyName) {
        return this.properties.getBooleanValue(this.storage, propertyName);
    }

    @Override
    @Nonnull
    public String getPersistenceValue(String propertyName) {
        return this.properties.getPersistenceValue(this.storage, propertyName);
    }

    @Override
    @Nonnull
    public BlockState getCurrentState() {
        return BlockState.of(this.blockId, this.storage);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getExactIntStorage() {
        return this.storage.intValueExact();
    }

    @Override
    @Nonnull
    public BigIntegerMutableBlockState copy() {
        return new BigIntegerMutableBlockState(this.getBlockId(), this.properties, this.storage);
    }

    @Override
    public String toString() {
        return "BigIntegerMutableBlockState(super=" + super.toString() + ", storage=" + this.storage + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BigIntegerMutableBlockState)) {
            return false;
        }
        BigIntegerMutableBlockState other = (BigIntegerMutableBlockState)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BigInteger this$storage = this.storage;
        BigInteger other$storage = other.storage;
        return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BigIntegerMutableBlockState;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BigInteger $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        return result;
    }
}

