/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.Server;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.MutableBlockState;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.HumanStringComparator;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public final class BlockStateRegistry {
    private static final Logger log;
    public static final int BIG_META_MASK = -1;
    private static final ExecutorService asyncStateRemover;
    private static final Pattern BLOCK_ID_NAME_PATTERN;
    private static final Set<String> LEGACY_NAME_SET;
    private static final Registration updateBlockRegistration;
    private static final Map<BlockState, Registration> blockStateRegistration;
    private static final Map<String, Registration> stateIdRegistration;
    private static final AtomicInteger runtimeIdAllocator;
    private static final Int2ObjectMap<String> blockIdToPersistenceName;
    private static final Map<String, Integer> persistenceNameToBlockId;
    private static final byte[] blockPaletteBytes;

    private static boolean isNameOwnerOfId(String name, int blockId) {
        return !name.equals("minecraft:wood") || blockId == 467;
    }

    @Nonnull
    private static String getStateId(CompoundTag block) {
        TreeMap<String, String> propertyMap = new TreeMap<String, String>(HumanStringComparator.getInstance());
        for (Tag tag : block.getCompound("states").getAllTags()) {
            propertyMap.put(tag.getName(), tag.parseValue().toString());
        }
        String blockName = block.getString("name");
        Preconditions.checkArgument(!blockName.isEmpty(), "Couldn't find the block name!");
        StringBuilder stateId = new StringBuilder(blockName);
        propertyMap.forEach((name, value) -> stateId.append(';').append((String)name).append('=').append((String)value));
        return stateId.toString();
    }

    public static int getRuntimeId(BlockState state) {
        return BlockStateRegistry.getRegistration(state).runtimeId;
    }

    private static Registration getRegistration(BlockState state) {
        return blockStateRegistration.computeIfAbsent(state, BlockStateRegistry::findRegistration);
    }

    public static int getRuntimeId(int blockId) {
        return BlockStateRegistry.getRuntimeId(BlockState.of(blockId));
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", replaceWith="getRuntimeId(BlockState state)", since="1.3.0.0-PN")
    public static int getRuntimeId(int blockId, int meta) {
        return BlockStateRegistry.getRuntimeId(BlockState.of(blockId, meta));
    }

    private static Registration findRegistration(BlockState state) {
        Registration airRegistration;
        if (state.getBlockId() == 0 && (airRegistration = blockStateRegistration.get(BlockState.AIR)) != null) {
            return new Registration(state, airRegistration.runtimeId);
        }
        Registration registration = state.getPropertyNames().equals(LEGACY_NAME_SET) ? BlockStateRegistry.logDiscoveryError(state) : BlockStateRegistry.findRegistrationByStateId(state);
        BlockStateRegistry.removeStateIdsAsync(registration);
        return registration;
    }

    private static Registration findRegistrationByStateId(BlockState state) {
        Registration registration;
        try {
            registration = stateIdRegistration.remove(state.getStateId());
            if (registration != null) {
                registration.state = state;
                return registration;
            }
        }
        catch (Exception e) {
            try {
                log.fatal("An error has occurred while trying to get the stateId of state: " + state.getBlockId() + ":" + state.getDataStorage() + " - " + state.getProperties() + " - " + (String)blockIdToPersistenceName.get(state.getBlockId()), (Throwable)e);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
                log.fatal("An error has occurred while trying to get the stateId of state: " + state.getBlockId() + ":" + state.getDataStorage(), (Throwable)e);
            }
        }
        try {
            registration = stateIdRegistration.remove(state.getLegacyStateId());
            if (registration != null) {
                registration.state = state;
                return registration;
            }
        }
        catch (Exception e) {
            log.fatal("An error has occurred while trying to parse the legacyStateId of " + state.getBlockId() + ":" + state.getDataStorage(), (Throwable)e);
        }
        return BlockStateRegistry.logDiscoveryError(state);
    }

    private static void removeStateIdsAsync(@Nullable Registration registration) {
        if (registration != null && registration != updateBlockRegistration) {
            asyncStateRemover.submit(() -> stateIdRegistration.values().removeIf(r -> ((Registration)r).runtimeId == registration.runtimeId));
        }
    }

    private static Registration logDiscoveryError(BlockState state) {
        log.error("Found an unknown BlockId:Meta combination: " + state.getBlockId() + ":" + state.getDataStorage() + " - " + state.getStateId() + " - " + state.getProperties() + " - " + (String)blockIdToPersistenceName.get(state.getBlockId()) + ", trying to repair or replacing with an \"UPDATE!\" block.");
        return updateBlockRegistration;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static List<String> getPersistenceNames() {
        return new ArrayList<String>(persistenceNameToBlockId.keySet());
    }

    @Nonnull
    public static String getPersistenceName(int blockId) {
        String persistenceName = (String)blockIdToPersistenceName.get(blockId);
        if (persistenceName == null) {
            String fallback = "blockid:" + blockId;
            log.warn("The persistence name of the block id " + blockId + " is unknown! Using " + fallback + " as an alternative!");
            BlockStateRegistry.registerPersistenceName(blockId, fallback);
            return fallback;
        }
        return persistenceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPersistenceName(int blockId, String persistenceName) {
        Int2ObjectMap<String> int2ObjectMap = blockIdToPersistenceName;
        synchronized (int2ObjectMap) {
            String newName = persistenceName.toLowerCase();
            String oldName = blockIdToPersistenceName.putIfAbsent(blockId, newName);
            if (oldName != null && !persistenceName.equalsIgnoreCase(oldName)) {
                throw new UnsupportedOperationException("The persistence name registration tried to replaced a name. Name:" + persistenceName + ", Old:" + oldName + ", Id:" + blockId);
            }
            Integer oldId = persistenceNameToBlockId.putIfAbsent(newName, blockId);
            if (oldId != null && blockId != oldId) {
                blockIdToPersistenceName.remove(blockId);
                throw new UnsupportedOperationException("The persistence name registration tried to replaced an id. Name:" + persistenceName + ", OldId:" + oldId + ", Id:" + blockId);
            }
        }
    }

    private static void registerStateId(CompoundTag state, int runtimeId) {
        Registration registration;
        String stateId = BlockStateRegistry.getStateId(state.getCompound("block"));
        Registration old = stateIdRegistration.putIfAbsent(stateId, registration = new Registration(null, runtimeId));
        if (old != null && !old.equals(registration)) {
            throw new UnsupportedOperationException("The persistence NBT registration tried to replaced a runtime id. Old:" + old + ", New:" + runtimeId + ", State:" + stateId);
        }
    }

    private static void registerState(int blockId, int meta, CompoundTag originalState, int runtimeId) {
        Registration registration;
        BlockState state = BlockState.of(blockId, meta);
        Registration old = blockStateRegistration.putIfAbsent(state, registration = new Registration(state, runtimeId));
        if (old != null && !registration.equals(old)) {
            throw new UnsupportedOperationException("The persistence NBT registration tried to replaced a runtime id. Old:" + old + ", New:" + runtimeId + ", State:" + state);
        }
        CompoundTag block = originalState.getCompound("block");
        stateIdRegistration.remove(BlockStateRegistry.getStateId(block));
        stateIdRegistration.remove(state.getLegacyStateId());
    }

    public static int getBlockPaletteDataVersion() {
        byte[] obj = blockPaletteBytes;
        return obj.hashCode();
    }

    @Nonnull
    public static byte[] getBlockPaletteBytes() {
        return (byte[])blockPaletteBytes.clone();
    }

    public static void putBlockPaletteBytes(BinaryStream stream) {
        stream.put(blockPaletteBytes);
    }

    public static int getBlockPaletteLength() {
        return blockPaletteBytes.length;
    }

    public static void copyBlockPaletteBytes(byte[] target, int targetIndex) {
        System.arraycopy(blockPaletteBytes, 0, target, targetIndex, blockPaletteBytes.length);
    }

    @Nonnull
    public static BlockProperties getProperties(int blockId) {
        Block block;
        int fullId = blockId << Block.DATA_BITS;
        if (fullId >= Block.fullList.length || (block = Block.fullList[fullId]) == null) {
            return BlockUnknown.PROPERTIES;
        }
        return block.getProperties();
    }

    @Nonnull
    public static MutableBlockState createMutableState(int blockId) {
        return BlockStateRegistry.getProperties(blockId).createMutableState(blockId);
    }

    @Nonnull
    public static MutableBlockState createMutableState(int blockId, int bigMeta) {
        MutableBlockState blockState = BlockStateRegistry.createMutableState(blockId);
        blockState.setDataStorageFromInt(bigMeta);
        return blockState;
    }

    @Nonnull
    public static MutableBlockState createMutableState(int blockId, Number storage) {
        MutableBlockState blockState = BlockStateRegistry.createMutableState(blockId);
        blockState.setDataStorage(storage);
        return blockState;
    }

    public static int getUpdateBlockRegistration() {
        return updateBlockRegistration.runtimeId;
    }

    @Nullable
    public static Integer getBlockId(String persistenceName) {
        Integer blockId = persistenceNameToBlockId.get(persistenceName);
        if (blockId != null) {
            return blockId;
        }
        Matcher matcher = BLOCK_ID_NAME_PATTERN.matcher(persistenceName);
        if (matcher.matches()) {
            try {
                return Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getFallbackRuntimeId() {
        return updateBlockRegistration.runtimeId;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BlockState getFallbackBlockState() {
        return updateBlockRegistration.state;
    }

    private BlockStateRegistry() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        ListTag tag;
        Throwable throwable;
        InputStream stream;
        log = LogManager.getLogger(BlockStateRegistry.class);
        asyncStateRemover = Executors.newSingleThreadExecutor();
        BLOCK_ID_NAME_PATTERN = Pattern.compile("^blockid:(\\d+)$");
        LEGACY_NAME_SET = Collections.singleton("nukkit-legacy");
        blockStateRegistration = new ConcurrentHashMap<BlockState, Registration>();
        stateIdRegistration = new ConcurrentHashMap<String, Registration>();
        runtimeIdAllocator = new AtomicInteger(0);
        blockIdToPersistenceName = new Int2ObjectOpenHashMap<String>();
        persistenceNameToBlockId = new LinkedHashMap<String, Integer>();
        LinkedHashMap<CompoundTag, List<CompoundTag>> metaOverrides = new LinkedHashMap<CompoundTag, List<CompoundTag>>();
        try {
            stream = Server.class.getClassLoader().getResourceAsStream("runtime_block_states_overrides.dat");
            throwable = null;
            try {
                ListTag<CompoundTag> states;
                if (stream == null) {
                    throw new AssertionError((Object)"Unable to locate block state nbt");
                }
                Throwable throwable2 = null;
                try (BufferedInputStream buffered = new BufferedInputStream(stream);){
                    states = NBTIO.read(buffered).getList("Overrides", CompoundTag.class);
                }
                catch (Throwable throwable3) {
                    Throwable throwable4 = throwable3;
                    throw throwable3;
                }
                for (CompoundTag compoundTag : states.getAll()) {
                    if (!compoundTag.contains("block") || !compoundTag.contains("LegacyStates")) continue;
                    metaOverrides.put(compoundTag.getCompound("block").remove("version"), compoundTag.getList("LegacyStates", CompoundTag.class).getAll());
                }
            }
            catch (Throwable states) {
                throwable = states;
                throw states;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable states) {
                            throwable.addSuppressed(states);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            stream = Server.class.getClassLoader().getResourceAsStream("block_ids.csv");
            throwable = null;
            try {
                if (stream == null) {
                    throw new AssertionError((Object)"Unable to locate block_ids.csv");
                }
                int count = 0;
                try {
                    Throwable throwable5 = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            ++count;
                            if ((line = line.trim()).isEmpty()) continue;
                            String[] parts = line.split(",");
                            Preconditions.checkArgument(parts.length == 2 || parts[0].matches("^[0-9]+$"));
                            if (parts.length <= 1 || !parts[1].startsWith("minecraft:")) continue;
                            int id = Integer.parseInt(parts[0]);
                            blockIdToPersistenceName.put(id, parts[1]);
                            persistenceNameToBlockId.put(parts[1], id);
                        }
                    }
                    catch (Throwable line) {
                        Throwable throwable6 = line;
                        throw line;
                    }
                }
                catch (Exception e) {
                    throw new IOException("Error reading the line " + count + " of the block_ids.csv", e);
                }
            }
            catch (Throwable count) {
                throwable = count;
                throw count;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable count) {
                            throwable.addSuppressed(count);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        try {
            InputStream stream2 = Server.class.getClassLoader().getResourceAsStream("runtime_block_states.dat");
            Object count = null;
            try {
                if (stream2 == null) {
                    throw new AssertionError((Object)"Unable to locate block state nbt");
                }
                Throwable throwable7 = null;
                try (BufferedInputStream buffered2 = new BufferedInputStream(stream2);){
                    tag = (ListTag)NBTIO.readTag(buffered2, ByteOrder.LITTLE_ENDIAN, false);
                }
                catch (Throwable line) {
                    Throwable throwable8 = line;
                    throw line;
                }
            }
            catch (Throwable buffered2) {
                count = buffered2;
                throw buffered2;
            }
            finally {
                if (stream2 != null) {
                    if (count != null) {
                        try {
                            stream2.close();
                        }
                        catch (Throwable buffered2) {
                            ((Throwable)count).addSuppressed(buffered2);
                        }
                    } else {
                        stream2.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        Registration infoUpdateRuntimeId = null;
        for (CompoundTag state : tag.getAll()) {
            List<CompoundTag> legacyStates;
            int n = runtimeIdAllocator.getAndIncrement();
            String name = state.getCompound("block").getString("name").toLowerCase();
            if (name.equals("minecraft:unknown")) {
                infoUpdateRuntimeId = new Registration(BlockState.of(600), n);
            }
            if ((legacyStates = (List<CompoundTag>)metaOverrides.get(state.getCompound("block").copy().remove("version"))) == null) {
                if (!state.contains("LegacyStates")) {
                    BlockStateRegistry.registerStateId(state, n);
                    continue;
                }
                legacyStates = state.getList("LegacyStates", CompoundTag.class).getAll();
            }
            if (legacyStates.isEmpty()) {
                BlockStateRegistry.registerStateId(state, n);
                continue;
            }
            CompoundTag firstState = (CompoundTag)legacyStates.get(0);
            int firstId = firstState.getInt("id");
            int firstMeta = firstState.getInt("val");
            if (BlockStateRegistry.isNameOwnerOfId(name, firstId)) {
                BlockStateRegistry.registerPersistenceName(firstId, name);
                BlockStateRegistry.registerStateId(state, n);
                BlockStateRegistry.registerState(firstId, firstMeta, state, n);
            }
            BlockStateRegistry.registerState(firstId, firstMeta, state, n);
            for (CompoundTag legacyState : legacyStates) {
                int newBlockId = legacyState.getInt("id");
                int meta = legacyState.getInt("val");
                BlockStateRegistry.registerState(newBlockId, meta, state, n);
                if (!BlockStateRegistry.isNameOwnerOfId(name, newBlockId)) continue;
                BlockStateRegistry.registerState(newBlockId, meta, state, n);
            }
            state.remove("meta");
            state.remove("LegacyStates");
        }
        if (infoUpdateRuntimeId == null) {
            throw new IllegalStateException("Could not find the minecraft:info_update runtime id!");
        }
        updateBlockRegistration = infoUpdateRuntimeId;
        try {
            blockPaletteBytes = NBTIO.write(tag, ByteOrder.LITTLE_ENDIAN, true);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class Registration {
        @Nullable
        private BlockState state;
        private final int runtimeId;

        public Registration(@Nullable BlockState state, int runtimeId) {
            this.state = state;
            this.runtimeId = runtimeId;
        }

        public String toString() {
            return "BlockStateRegistry.Registration(state=" + this.state + ", runtimeId=" + this.runtimeId + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Registration)) {
                return false;
            }
            Registration other = (Registration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BlockState this$state = this.state;
            BlockState other$state = other.state;
            if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
                return false;
            }
            return this.runtimeId == other.runtimeId;
        }

        protected boolean canEqual(Object other) {
            return other instanceof Registration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BlockState $state = this.state;
            result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
            result = result * 59 + this.runtimeId;
            return result;
        }
    }
}

