/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockproperty.BlockProperty;
import cn.nukkit.blockproperty.exception.InvalidBlockPropertyException;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.BlockStateRepair;
import cn.nukkit.blockstate.IBlockState;
import cn.nukkit.blockstate.Loggers;
import cn.nukkit.blockstate.exception.InvalidBlockStateDataTypeException;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.Validation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public interface IMutableBlockState
extends IBlockState {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void setState(IBlockState state) throws InvalidBlockStateException {
        if (state.getBlockId() != this.getBlockId()) {
            throw new UnsupportedOperationException();
        }
        this.setDataStorage(state.getDataStorage());
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setDataStorage(@Nonnegative Number var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setDataStorageFromInt(@Nonnegative int var1);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setDataStorage(@Nonnegative Number storage, boolean repair) {
        return this.setDataStorage(storage, repair, null);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setDataStorageFromInt(@Nonnegative int storage, boolean repair) {
        return this.setDataStorageFromInt(storage, repair, null);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setDataStorage(@Nonnegative Number storage, boolean repair, @Nullable Consumer<BlockStateRepair> callback) {
        try {
            this.setDataStorage(storage);
            return false;
        }
        catch (InvalidBlockStateException e) {
            if (repair) {
                BigInteger bigInteger;
                try {
                    bigInteger = new BigDecimal(storage.toString()).toBigIntegerExact();
                }
                catch (ArithmeticException | NumberFormatException e2) {
                    InvalidBlockStateDataTypeException ex = new InvalidBlockStateDataTypeException(storage, (Throwable)e2);
                    ex.addSuppressed(e);
                    throw ex;
                }
                try {
                    this.setDataStorage(IMutableBlockState.repairStorage(this.getBlockId(), bigInteger, this.getProperties(), callback));
                }
                catch (InvalidBlockPropertyException | InvalidBlockStateException e2) {
                    InvalidBlockStateException ex = new InvalidBlockStateException(e.getState(), "The state is invalid and could not be repaired", e);
                    ex.addSuppressed(e2);
                    throw ex;
                }
                return true;
            }
            throw e;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setDataStorageFromInt(@Nonnegative int storage, boolean repair, @Nullable Consumer<BlockStateRepair> callback) {
        try {
            this.setDataStorageFromInt(storage);
            return false;
        }
        catch (InvalidBlockPropertyException | IllegalStateException e) {
            if (repair) {
                this.setDataStorage(IMutableBlockState.repairStorage(this.getBlockId(), BigInteger.valueOf(storage), this.getProperties(), callback));
                return true;
            }
            throw e;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setPropertyValue(String var1, @Nullable Serializable var2);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBooleanValue(String var1, boolean var2);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setIntValue(String var1, int var2);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void setBooleanValue(BlockProperty<Boolean> property, boolean value) {
        this.setBooleanValue(property.getName(), value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public void setIntValue(BlockProperty<Integer> property, int value) {
        this.setIntValue(property.getName(), value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public <T extends Serializable> void setPropertyValue(BlockProperty<T> property, @Nullable T value) {
        this.setPropertyValue(property.getName(), value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean toggleBooleanProperty(String propertyName) {
        boolean newValue = !this.getBooleanValue(propertyName);
        this.setBooleanValue(propertyName, newValue);
        return newValue;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean toggleBooleanProperty(BlockProperty<Boolean> property) {
        return this.toggleBooleanProperty(property.getName());
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static BigInteger repairStorage(@Nonnegative int blockId, @Nonnull BigInteger storage, @Nonnull BlockProperties properties, @Nullable Consumer<BlockStateRepair> callback) {
        Validation.checkPositive("blockId", blockId);
        int checkedBits = 0;
        int repairs = 0;
        BigInteger current = storage;
        for (BlockProperties.RegisteredBlockProperty reg : properties.getAllProperties()) {
            checkedBits += reg.getProperty().getBitSize();
            try {
                reg.validateMeta(current);
            }
            catch (InvalidBlockPropertyException e) {
                BlockProperty<?> property = reg.getProperty();
                int offset = reg.getOffset();
                BigInteger next = property.setValue(current, offset, null);
                if (callback != null) {
                    Object fixed = property.getValue(next, offset);
                    BlockStateRepair stateRepair = new BlockStateRepair(blockId, properties, storage, current, next, repairs++, property, offset, property.getMetaFromBigInt(current, offset), (Serializable)fixed, (Serializable)fixed, e);
                    callback.accept(stateRepair);
                    Serializable proposed = stateRepair.getProposedPropertyValue();
                    if (!fixed.equals(proposed)) {
                        try {
                            next = property.setValue(current, offset, proposed);
                        }
                        catch (InvalidBlockPropertyException proposedFailed) {
                            Loggers.logIMutableBlockState.warn("Could not apply the proposed repair, using the default proposal. " + stateRepair, (Throwable)proposedFailed);
                        }
                    }
                }
                current = next;
            }
        }
        if (NukkitMath.bitLength(current) > checkedBits) {
            BigInteger validMask = BigInteger.ONE.shiftLeft(checkedBits).subtract(BigInteger.ONE);
            BigInteger next = current.and(validMask);
            if (callback != null) {
                BlockStateRepair stateRepair = new BlockStateRepair(blockId, properties, storage, current, next, repairs, null, checkedBits, current.shiftRight(checkedBits).intValue(), Integer.valueOf(0), Integer.valueOf(0), null);
                callback.accept(stateRepair);
                if (!Integer.valueOf(0).equals(stateRepair.getProposedPropertyValue())) {
                    Loggers.logIMutableBlockState.warn("Could not apply the proposed repair, using the default proposal. " + stateRepair, (Throwable)new IllegalStateException("Attempted to propose a value outside the properties boundary"));
                }
            }
            current = next;
        }
        return current;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static RuntimeException handleUnsupportedStorageType(@Nonnegative int blockId, @Nonnegative Number storage, RuntimeException e) {
        InvalidBlockStateException ex;
        try {
            ex = new InvalidBlockStateException(BlockState.of(blockId, storage), (Throwable)e);
        }
        catch (InvalidBlockStateDataTypeException e2) {
            e2.addSuppressed(e);
            return e2;
        }
        return ex;
    }
}

