/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockstate;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.api.Unsigned;
import cn.nukkit.blockproperty.BlockProperties;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.IMutableBlockState;
import cn.nukkit.blockstate.MutableBlockState;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class ZeroMutableBlockState
extends MutableBlockState {
    private final BlockState state;

    public ZeroMutableBlockState(int blockId, BlockProperties properties) {
        super(blockId, properties);
        this.state = BlockState.of(blockId);
    }

    @Override
    public void validate() {
    }

    @Override
    @Nonnull
    public MutableBlockState copy() {
        return this;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorage(@Nonnegative Number storage) {
        int state;
        Class<?> c = storage.getClass();
        if (c == Integer.class || c == Short.class || c == Byte.class) {
            state = storage.intValue();
        } else {
            try {
                state = new BigDecimal(storage.toString()).intValueExact();
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw IMutableBlockState.handleUnsupportedStorageType(this.getBlockId(), storage, e);
            }
        }
        if (state != 0) {
            throw IMutableBlockState.handleUnsupportedStorageType(this.getBlockId(), storage, new ArithmeticException("ZeroMutableBlockState only accepts zero"));
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setDataStorageFromInt(@Nonnegative int storage) {
        if (storage != 0) {
            throw IMutableBlockState.handleUnsupportedStorageType(this.getBlockId(), storage, new ArithmeticException("ZeroMutableBlockState only accepts zero"));
        }
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setPropertyValue(String propertyName, @Nullable Serializable value) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted to set " + propertyName + " to " + value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setBooleanValue(String propertyName, boolean value) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted to set " + propertyName + " to " + value);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void setIntValue(String propertyName, int value) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted to set " + propertyName + " to " + value);
    }

    @Override
    @Nonnegative
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Number getDataStorage() {
        return 0;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean isDefaultState() {
        return true;
    }

    @Override
    @Nonnegative
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getLegacyDamage() {
        return 0;
    }

    @Override
    @Unsigned
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getBigDamage() {
        return 0;
    }

    @Override
    @Nonnegative
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BigInteger getHugeDamage() {
        return BigInteger.ZERO;
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public Serializable getPropertyValue(String propertyName) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted get property " + propertyName);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getIntValue(String propertyName) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted get property " + propertyName);
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public boolean getBooleanValue(String propertyName) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted get property " + propertyName);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public String getPersistenceValue(String propertyName) {
        throw new NoSuchElementException("ZeroMutableBlockState can't have properties. Attempted get property " + propertyName);
    }

    @Override
    @Nonnull
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockState getCurrentState() {
        return this.state;
    }

    @Override
    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public int getExactIntStorage() {
        return 0;
    }
}

