/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command;

import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.TextFormat;
import io.netty.util.internal.EmptyArrays;
import java.util.ArrayList;
import java.util.List;

public class FormattedCommandAlias
extends Command {
    private final String[] formatStrings;

    public FormattedCommandAlias(String alias, String[] formatStrings) {
        super(alias);
        this.formatStrings = formatStrings;
    }

    public FormattedCommandAlias(String alias, List<String> formatStrings) {
        super(alias);
        this.formatStrings = formatStrings.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        boolean result = false;
        ArrayList<String> commands = new ArrayList<String>();
        for (String formatString : this.formatStrings) {
            try {
                commands.add(this.buildCommand(formatString, args));
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    sender.sendMessage((Object)((Object)TextFormat.RED) + e.getMessage());
                } else {
                    sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.exception"));
                    MainLogger logger = sender.getServer().getLogger();
                    if (logger != null) {
                        logger.logException(e);
                    }
                }
                return false;
            }
        }
        for (String command : commands) {
            result |= Server.getInstance().dispatchCommand(sender, command);
        }
        return result;
    }

    private String buildCommand(String formatString, String[] args) {
        int index = formatString.indexOf("$");
        while (index != -1) {
            int start = index;
            if (index > 0 && formatString.charAt(start - 1) == '\\') {
                formatString = formatString.substring(0, start - 1) + formatString.substring(start);
                index = formatString.indexOf("$", index);
                continue;
            }
            boolean required = false;
            if (formatString.charAt(index + 1) == '$') {
                required = true;
                ++index;
            }
            int argStart = ++index;
            while (index < formatString.length() && FormattedCommandAlias.inRange(formatString.charAt(index) - 48, 0, 9)) {
                ++index;
            }
            if (argStart == index) {
                throw new IllegalArgumentException("Invalid replacement token");
            }
            int position = Integer.parseInt(formatString.substring(argStart, index));
            if (position == 0) {
                throw new IllegalArgumentException("Invalid replacement token");
            }
            --position;
            boolean rest = false;
            if (index < formatString.length() && formatString.charAt(index) == '-') {
                rest = true;
            }
            int end = ++index;
            if (required && position >= args.length) {
                throw new IllegalArgumentException("Missing required argument " + (position + 1));
            }
            StringBuilder replacement = new StringBuilder();
            if (rest && position < args.length) {
                for (int i = position; i < args.length; ++i) {
                    if (i != position) {
                        replacement.append(' ');
                    }
                    replacement.append(args[i]);
                }
            } else if (position < args.length) {
                replacement.append(args[position]);
            }
            formatString = formatString.substring(0, start) + replacement.toString() + formatString.substring(end);
            index = start + replacement.length();
            index = formatString.indexOf("$", index);
        }
        return formatString;
    }

    private static boolean inRange(int i, int j, int k) {
        return i >= j && i <= k;
    }
}

