/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandEnum;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.TextFormat;

public class GamemodeCommand
extends VanillaCommand {
    public GamemodeCommand(String name) {
        super(name, "%nukkit.command.gamemode.description", "%commands.gamemode.usage", new String[]{"gm"});
        this.setPermission("nukkit.command.gamemode.survival;nukkit.command.gamemode.creative;nukkit.command.gamemode.adventure;nukkit.command.gamemode.spectator;nukkit.command.gamemode.other");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("gameMode", CommandParamType.INT), CommandParameter.newType("player", true, CommandParamType.TARGET)});
        this.commandParameters.put("byString", new CommandParameter[]{CommandParameter.newEnum("gameMode", CommandEnum.ENUM_GAMEMODE), CommandParameter.newType("player", true, CommandParamType.TARGET)});
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        int gameMode = Server.getGamemodeFromString(args[0]);
        if (gameMode == -1) {
            sender.sendMessage("Unknown game mode");
            return true;
        }
        CommandSender target = sender;
        if (args.length > 1) {
            if (!sender.hasPermission("nukkit.command.gamemode.other")) {
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.permission"));
                return true;
            }
            target = sender.getServer().getPlayer(args[1]);
            if (target == null) {
                sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.player.notFound"));
                return true;
            }
        } else if (!(sender instanceof Player)) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        if (gameMode == 0 && !sender.hasPermission("nukkit.command.gamemode.survival") || gameMode == 1 && !sender.hasPermission("nukkit.command.gamemode.creative") || gameMode == 2 && !sender.hasPermission("nukkit.command.gamemode.adventure") || gameMode == 3 && !sender.hasPermission("nukkit.command.gamemode.spectator")) {
            sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.permission"));
            return true;
        }
        if (!((Player)target).setGamemode(gameMode)) {
            sender.sendMessage("Game mode update for " + target.getName() + " failed");
            return true;
        }
        if (target.equals(sender)) {
            Command.broadcastCommandMessage(sender, new TranslationContainer("commands.gamemode.success.self", Server.getGamemodeString(gameMode)));
            return true;
        }
        target.sendMessage(new TranslationContainer("gameMode.changed"));
        Command.broadcastCommandMessage(sender, new TranslationContainer("commands.gamemode.success.other", Server.getGamemodeString(gameMode), target.getName()));
        return true;
    }
}

