/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Nukkit;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.level.Level;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.utils.TextFormat;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class StatusCommand
extends VanillaCommand {
    private static final String UPTIME_FORMAT = (Object)((Object)TextFormat.RED) + "%d" + (Object)((Object)TextFormat.GOLD) + " days " + (Object)((Object)TextFormat.RED) + "%d" + (Object)((Object)TextFormat.GOLD) + " hours " + (Object)((Object)TextFormat.RED) + "%d" + (Object)((Object)TextFormat.GOLD) + " minutes " + (Object)((Object)TextFormat.RED) + "%d" + (Object)((Object)TextFormat.GOLD) + " seconds";

    public StatusCommand(String name) {
        super(name, "%nukkit.command.status.description", "%nukkit.command.status.usage");
        this.setPermission("nukkit.command.status");
        this.commandParameters.clear();
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        Server server = sender.getServer();
        sender.sendMessage((Object)((Object)TextFormat.GREEN) + "---- " + (Object)((Object)TextFormat.WHITE) + "Server status" + (Object)((Object)TextFormat.GREEN) + " ----");
        long time = System.currentTimeMillis() - Nukkit.START_TIME;
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Uptime: " + StatusCommand.formatUptime(time));
        TextFormat tpsColor = TextFormat.GREEN;
        float tps = server.getTicksPerSecond();
        if (tps < 17.0f) {
            tpsColor = TextFormat.GOLD;
        } else if (tps < 12.0f) {
            tpsColor = TextFormat.RED;
        }
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Current TPS: " + (Object)((Object)tpsColor) + NukkitMath.round(tps, 2));
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Load: " + (Object)((Object)tpsColor) + server.getTickUsage() + "%");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Network upload: " + (Object)((Object)TextFormat.GREEN) + NukkitMath.round(server.getNetwork().getUpload() / 1024.0 * 1000.0, 2) + " kB/s");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Network download: " + (Object)((Object)TextFormat.GREEN) + NukkitMath.round(server.getNetwork().getDownload() / 1024.0 * 1000.0, 2) + " kB/s");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Thread count: " + (Object)((Object)TextFormat.GREEN) + Thread.getAllStackTraces().size());
        Runtime runtime = Runtime.getRuntime();
        double totalMB = NukkitMath.round((double)runtime.totalMemory() / 1024.0 / 1024.0, 2);
        double usedMB = NukkitMath.round((double)(runtime.totalMemory() - runtime.freeMemory()) / 1024.0 / 1024.0, 2);
        double maxMB = NukkitMath.round((double)runtime.maxMemory() / 1024.0 / 1024.0, 2);
        double usage = usedMB / maxMB * 100.0;
        TextFormat usageColor = TextFormat.GREEN;
        if (usage > 85.0) {
            usageColor = TextFormat.GOLD;
        }
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Used memory: " + (Object)((Object)usageColor) + usedMB + " MB. (" + NukkitMath.round(usage, 2) + "%)");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Total memory: " + (Object)((Object)TextFormat.RED) + totalMB + " MB.");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Maximum VM memory: " + (Object)((Object)TextFormat.RED) + maxMB + " MB.");
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Available processors: " + (Object)((Object)TextFormat.GREEN) + runtime.availableProcessors());
        TextFormat playerColor = TextFormat.GREEN;
        if ((double)((float)server.getOnlinePlayers().size() / (float)server.getMaxPlayers()) > 0.85) {
            playerColor = TextFormat.GOLD;
        }
        sender.sendMessage((Object)((Object)TextFormat.GOLD) + "Players: " + (Object)((Object)playerColor) + server.getOnlinePlayers().size() + (Object)((Object)TextFormat.GREEN) + " online, " + (Object)((Object)TextFormat.RED) + server.getMaxPlayers() + (Object)((Object)TextFormat.GREEN) + " max. ");
        for (Level level : server.getLevels().values()) {
            sender.sendMessage((Object)((Object)TextFormat.GOLD) + "World \"" + level.getFolderName() + "\"" + (!Objects.equals(level.getFolderName(), level.getName()) ? " (" + level.getName() + ")" : "") + ": " + (Object)((Object)TextFormat.RED) + level.getChunks().size() + (Object)((Object)TextFormat.GREEN) + " chunks, " + (Object)((Object)TextFormat.RED) + level.getEntities().length + (Object)((Object)TextFormat.GREEN) + " entities, " + (Object)((Object)TextFormat.RED) + level.getBlockEntities().size() + (Object)((Object)TextFormat.GREEN) + " blockEntities. Time " + (Object)((Object)(level.getTickRate() > 1 || level.getTickRateTime() > 40 ? TextFormat.RED : TextFormat.YELLOW)) + NukkitMath.round(level.getTickRateTime(), 2) + "ms" + (level.getTickRate() > 1 ? " (tick rate " + (19 - level.getTickRate()) + ")" : ""));
        }
        return true;
    }

    private static String formatUptime(long uptime) {
        long days = TimeUnit.MILLISECONDS.toDays(uptime);
        long hours = TimeUnit.MILLISECONDS.toHours(uptime -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(uptime -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(uptime -= TimeUnit.MINUTES.toMillis(minutes));
        return String.format(UPTIME_FORMAT, days, hours, minutes, seconds);
    }
}

