/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.TextFormat;

public class XpCommand
extends Command {
    public XpCommand(String name) {
        super(name, "%nukkit.command.xp.description", "%commands.xp.usage");
        this.setPermission("nukkit.command.xp");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("amount", CommandParamType.INT), CommandParameter.newType("player", true, CommandParamType.TARGET)});
        this.commandParameters.put("level", new CommandParameter[]{CommandParameter.newPostfix("amount", "l"), CommandParameter.newType("player", true, CommandParamType.TARGET)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        int amount;
        Player player;
        String amountString;
        if (!this.testPermission(sender)) {
            return true;
        }
        if (!(sender instanceof Player)) {
            if (args.length != 2) {
                sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
                return true;
            }
            amountString = args[0];
            String playerName = args[1];
            player = sender.getServer().getPlayer(playerName);
        } else if (args.length == 1) {
            amountString = args[0];
            player = (Player)sender;
        } else if (args.length == 2) {
            amountString = args[0];
            String playerName = args[1];
            player = sender.getServer().getPlayer(playerName);
        } else {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        if (player == null) {
            sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.generic.player.notFound"));
            return true;
        }
        boolean isLevel = false;
        if (amountString.endsWith("l") || amountString.endsWith("L")) {
            amountString = amountString.substring(0, amountString.length() - 1);
            isLevel = true;
        }
        try {
            amount = Integer.parseInt(amountString);
        }
        catch (NumberFormatException e1) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        if (isLevel) {
            int newLevel = player.getExperienceLevel();
            if ((newLevel += amount) > 24791) {
                newLevel = 24791;
            }
            if (newLevel < 0) {
                player.setExperience(0, 0);
            } else {
                player.setExperience(player.getExperience(), newLevel, true);
            }
            if (amount > 0) {
                sender.sendMessage(new TranslationContainer("commands.xp.success.levels", String.valueOf(amount), player.getName()));
            } else {
                sender.sendMessage(new TranslationContainer("commands.xp.success.levels.minus", String.valueOf(-amount), player.getName()));
            }
            return true;
        }
        if (amount < 0) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return true;
        }
        player.addExperience(amount);
        sender.sendMessage(new TranslationContainer("commands.xp.success", String.valueOf(amount), player.getName()));
        return true;
    }
}

