/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.console;

import cn.nukkit.Server;
import cn.nukkit.console.NukkitConsoleCompleter;
import cn.nukkit.event.server.ServerCommandEvent;
import co.aikar.timings.Timings;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;

public class NukkitConsole
extends SimpleTerminalConsole {
    private final Server server;
    private final BlockingQueue<String> consoleQueue = new LinkedBlockingQueue<String>();
    private AtomicBoolean executingCommands = new AtomicBoolean(false);

    @Override
    protected boolean isRunning() {
        return this.server.isRunning();
    }

    @Override
    protected void runCommand(String command) {
        if (this.executingCommands.get()) {
            Timings.serverCommandTimer.startTiming();
            ServerCommandEvent event = new ServerCommandEvent(this.server.getConsoleSender(), command);
            if (this.server.getPluginManager() != null) {
                this.server.getPluginManager().callEvent(event);
            }
            if (!event.isCancelled()) {
                Server.getInstance().getScheduler().scheduleTask(() -> this.server.dispatchCommand(event.getSender(), event.getCommand()));
            }
            Timings.serverCommandTimer.stopTiming();
        } else {
            this.consoleQueue.add(command);
        }
    }

    public String readLine() {
        try {
            return this.consoleQueue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void shutdown() {
        this.server.shutdown();
    }

    @Override
    protected LineReader buildReader(LineReaderBuilder builder) {
        builder.completer(new NukkitConsoleCompleter(this.server));
        builder.appName("Nukkit");
        builder.option(LineReader.Option.HISTORY_BEEP, false);
        builder.option(LineReader.Option.HISTORY_IGNORE_DUPS, true);
        builder.option(LineReader.Option.HISTORY_IGNORE_SPACE, true);
        return super.buildReader(builder);
    }

    public boolean isExecutingCommands() {
        return this.executingCommands.get();
    }

    public void setExecutingCommands(boolean executingCommands) {
        if (this.executingCommands.compareAndSet(!executingCommands, executingCommands) && executingCommands) {
            this.consoleQueue.clear();
        }
    }

    public NukkitConsole(Server server) {
        this.server = server;
    }
}

