/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockMagma;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityDamageable;
import cn.nukkit.entity.EntityRideable;
import cn.nukkit.entity.data.ShortEntityData;
import cn.nukkit.entity.passive.EntityWaterAnimal;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.entity.weather.EntityWeather;
import cn.nukkit.event.entity.EntityDamageBlockedEvent;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityDeathEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemTurtleShell;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Position;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.network.protocol.AnimatePacket;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.EntityEventPacket;
import cn.nukkit.utils.BlockIterator;
import cn.nukkit.utils.Utils;
import co.aikar.timings.Timings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public abstract class EntityLiving
extends Entity
implements EntityDamageable {
    protected int attackTime = 0;
    private boolean attackTimeByShieldKb;
    private int attackTimeBefore;
    protected boolean invisible = false;
    protected float movementSpeed = 0.1f;
    protected int turtleTicks = 200;

    public EntityLiving(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected float getGravity() {
        return 0.08f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.namedTag.contains("HealF")) {
            this.namedTag.putFloat("Health", this.namedTag.getShort("HealF"));
            this.namedTag.remove("HealF");
        }
        if (!this.namedTag.contains("Health") || !(this.namedTag.get("Health") instanceof FloatTag)) {
            this.namedTag.putFloat("Health", this.getMaxHealth());
        }
        this.health = this.namedTag.getFloat("Health");
    }

    @Override
    public void setHealth(float health) {
        boolean wasAlive = this.isAlive();
        super.setHealth(health);
        if (this.isAlive() && !wasAlive) {
            EntityEventPacket pk = new EntityEventPacket();
            pk.eid = this.getId();
            pk.event = 18;
            Server.broadcastPacket(this.hasSpawned.values(), (DataPacket)pk);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putFloat("Health", this.getHealth());
    }

    public boolean hasLineOfSight(Entity entity) {
        return true;
    }

    public void collidingWith(Entity ent) {
        ent.applyEntityCollision(this);
    }

    @Override
    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    public boolean attack(EntityDamageEvent source) {
        EntityDamageEvent lastCause;
        if (this.noDamageTicks > 0) {
            return false;
        }
        if (this.attackTime > 0 && !this.attackTimeByShieldKb && (lastCause = this.getLastDamageCause()) != null && lastCause.getDamage() >= source.getDamage()) {
            return false;
        }
        if (this.isBlocking() && this.blockedByShield(source)) {
            return false;
        }
        if (super.attack(source)) {
            if (source instanceof EntityDamageByEntityEvent) {
                Entity damager = ((EntityDamageByEntityEvent)source).getDamager();
                if (source instanceof EntityDamageByChildEntityEvent) {
                    damager = ((EntityDamageByChildEntityEvent)source).getChild();
                }
                if (damager instanceof Player && !damager.onGround) {
                    AnimatePacket animate = new AnimatePacket();
                    animate.action = AnimatePacket.Action.CRITICAL_HIT;
                    animate.eid = this.getId();
                    this.getLevel().addChunkPacket(damager.getChunkX(), damager.getChunkZ(), animate);
                    this.getLevel().addSound(this, Sound.GAME_PLAYER_ATTACK_STRONG);
                    source.setDamage(source.getDamage() * 1.5f);
                }
                if (damager.isOnFire() && !(damager instanceof Player)) {
                    this.setOnFire(2 * this.server.getDifficulty());
                }
                double deltaX = this.x - damager.x;
                double deltaZ = this.z - damager.z;
                this.knockBack(damager, source.getDamage(), deltaX, deltaZ, ((EntityDamageByEntityEvent)source).getKnockBack());
            }
            EntityEventPacket pk = new EntityEventPacket();
            pk.eid = this.getId();
            pk.event = this.getHealth() <= 0.0f ? 3 : 2;
            Server.broadcastPacket(this.hasSpawned.values(), (DataPacket)pk);
            this.attackTime = source.getAttackCooldown();
            this.attackTimeByShieldKb = false;
            this.scheduleUpdate();
            return true;
        }
        return false;
    }

    public void knockBack(Entity attacker, double damage, double x, double z) {
        this.knockBack(attacker, damage, x, z, 0.4);
    }

    public void knockBack(Entity attacker, double damage, double x, double z, double base) {
        double f = Math.sqrt(x * x + z * z);
        if (f <= 0.0) {
            return;
        }
        f = 1.0 / f;
        Vector3 motion = new Vector3(this.motionX, this.motionY, this.motionZ);
        motion.x /= 2.0;
        motion.y /= 2.0;
        motion.z /= 2.0;
        motion.x += x * f * base;
        motion.y += base;
        motion.z += z * f * base;
        if (motion.y > base) {
            motion.y = base;
        }
        this.setMotion(motion);
    }

    @Override
    public void kill() {
        if (!this.isAlive()) {
            return;
        }
        super.kill();
        EntityDeathEvent ev = new EntityDeathEvent(this, this.getDrops());
        this.server.getPluginManager().callEvent(ev);
        if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
            for (Item item : ev.getDrops()) {
                this.getLevel().dropItem(this, item);
            }
        }
    }

    @Override
    public boolean entityBaseTick() {
        return this.entityBaseTick(1);
    }

    @Override
    public boolean entityBaseTick(int tickDiff) {
        Block block;
        boolean isBreathing;
        Timings.livingEntityBaseTickTimer.startTiming();
        boolean bl = isBreathing = !this.isInsideOfWater();
        if (this instanceof Player && (((Player)this).isCreative() || ((Player)this).isSpectator())) {
            isBreathing = true;
        }
        if (this instanceof Player) {
            if (!isBreathing && ((Player)this).getInventory().getHelmet() instanceof ItemTurtleShell) {
                if (this.turtleTicks > 0) {
                    isBreathing = true;
                    --this.turtleTicks;
                }
            } else {
                this.turtleTicks = 200;
            }
        }
        this.setDataFlag(0, 35, isBreathing);
        boolean hasUpdate = super.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            int airTicks;
            if (this.isInsideOfSolid()) {
                hasUpdate = true;
                this.attack(new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.SUFFOCATION, 1.0f));
            }
            if (this.isOnLadder() || this.hasEffect(24)) {
                this.resetFallDistance();
            }
            if (!this.hasEffect(13) && !this.hasEffect(26) && this.isInsideOfWater()) {
                if (this instanceof EntityWaterAnimal || this instanceof Player && (((Player)this).isCreative() || ((Player)this).isSpectator())) {
                    this.setAirTicks(400);
                } else if (this.turtleTicks == 0 || this.turtleTicks == 200) {
                    hasUpdate = true;
                    airTicks = this.getAirTicks() - tickDiff;
                    if (airTicks <= -20) {
                        airTicks = 0;
                        this.attack(new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.DROWNING, 2.0f));
                    }
                    this.setAirTicks(airTicks);
                }
            } else if (this instanceof EntityWaterAnimal) {
                hasUpdate = true;
                airTicks = this.getAirTicks() - tickDiff;
                if (airTicks <= -20) {
                    airTicks = 0;
                    this.attack(new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.SUFFOCATION, 2.0f));
                }
                this.setAirTicks(airTicks);
            } else {
                airTicks = this.getAirTicks();
                if (airTicks < 400) {
                    this.setAirTicks(Math.min(400, airTicks + tickDiff * 5));
                }
            }
        }
        if (this.attackTime > 0) {
            this.attackTime -= tickDiff;
            if (this.attackTime <= 0) {
                this.attackTimeByShieldKb = false;
            }
            hasUpdate = true;
        }
        if (this.riding == null) {
            for (Entity entity : this.level.getNearbyEntities(this.boundingBox.grow(0.2f, 0.0, 0.2f), this)) {
                if (!(entity instanceof EntityRideable)) continue;
                this.collidingWith(entity);
            }
        }
        if ((block = this.level.getBlock((int)this.x, (int)this.y - 1, (int)this.z)) instanceof BlockMagma) {
            block.onEntityCollide(this);
        }
        Timings.livingEntityBaseTickTimer.stopTiming();
        return hasUpdate;
    }

    public Item[] getDrops() {
        return Item.EMPTY_ARRAY;
    }

    public Block[] getLineOfSight(int maxDistance) {
        return this.getLineOfSight(maxDistance, 0);
    }

    public Block[] getLineOfSight(int maxDistance, int maxLength) {
        return this.getLineOfSight(maxDistance, maxLength, new Integer[0]);
    }

    @Deprecated
    public Block[] getLineOfSight(int maxDistance, int maxLength, Map<Integer, Object> transparent) {
        return this.getLineOfSight(maxDistance, maxLength, transparent.keySet().toArray(Utils.EMPTY_INTEGERS));
    }

    public Block[] getLineOfSight(int maxDistance, int maxLength, Integer[] transparent) {
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        if (transparent != null && transparent.length == 0) {
            transparent = null;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator(this.level, this.getPosition(), this.getDirectionVector(), this.getEyeHeight(), maxDistance);
        while (itr.hasNext()) {
            Block block = itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            int id = block.getId();
            if (!(transparent == null ? id != 0 : Arrays.binarySearch((Object[])transparent, (Object)id) < 0)) continue;
            break;
        }
        return blocks.toArray(Block.EMPTY_ARRAY);
    }

    public Block getTargetBlock(int maxDistance) {
        return this.getTargetBlock(maxDistance, new Integer[0]);
    }

    @Deprecated
    public Block getTargetBlock(int maxDistance, Map<Integer, Object> transparent) {
        return this.getTargetBlock(maxDistance, transparent.keySet().toArray(Utils.EMPTY_INTEGERS));
    }

    public Block getTargetBlock(int maxDistance, Integer[] transparent) {
        block4: {
            try {
                Block[] blocks = this.getLineOfSight(maxDistance, 1, transparent);
                Block block = blocks[0];
                if (block == null) break block4;
                if (transparent != null && transparent.length != 0) {
                    if (Arrays.binarySearch((Object[])transparent, (Object)block.getId()) < 0) {
                        return block;
                    }
                    break block4;
                }
                return block;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setMovementSpeed(float speed) {
        this.movementSpeed = speed;
    }

    public float getMovementSpeed() {
        return this.movementSpeed;
    }

    public int getAirTicks() {
        return this.getDataPropertyShort(7);
    }

    public void setAirTicks(int ticks) {
        this.setDataProperty(new ShortEntityData(7, ticks));
    }

    protected boolean blockedByShield(EntityDamageEvent source) {
        Entity damager = null;
        if (source instanceof EntityDamageByChildEntityEvent) {
            damager = ((EntityDamageByChildEntityEvent)source).getChild();
        } else if (source instanceof EntityDamageByEntityEvent) {
            damager = ((EntityDamageByEntityEvent)source).getDamager();
        }
        if (damager == null || damager instanceof EntityWeather || !this.isBlocking()) {
            return false;
        }
        Position entityPos = damager.getPosition();
        Vector3 direction = this.getDirectionVector();
        Vector3 normalizedVector = this.getPosition().subtract(entityPos).normalize();
        boolean blocked = normalizedVector.x * direction.x + normalizedVector.z * direction.z < 0.0;
        boolean knockBack = !(damager instanceof EntityProjectile);
        EntityDamageBlockedEvent event = new EntityDamageBlockedEvent(this, source, knockBack, true);
        if (!blocked || !source.canBeReducedByArmor()) {
            event.setCancelled();
        }
        this.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        if (event.getKnockBackAttacker() && damager instanceof EntityLiving) {
            EntityLiving attacker = (EntityLiving)damager;
            double deltaX = attacker.getX() - this.getX();
            double deltaZ = attacker.getZ() - this.getZ();
            attacker.knockBack(this, 0.0, deltaX, deltaZ);
            attacker.attackTime = 10;
            attacker.attackTimeByShieldKb = true;
        }
        this.onBlock(damager, event.getAnimation());
        return true;
    }

    protected void onBlock(Entity entity, boolean animate) {
        if (animate) {
            this.getLevel().addSound(this, Sound.ITEM_SHIELD_BLOCK);
        }
    }

    public boolean isBlocking() {
        return this.getDataFlag(91, 71);
    }

    public void setBlocking(boolean value) {
        this.setDataFlag(91, 71, value);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void preAttack(Player player) {
        if (this.attackTimeByShieldKb) {
            this.attackTimeBefore = this.attackTime;
            this.attackTime = 0;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void postAttack(Player player) {
        if (this.attackTimeByShieldKb && this.attackTime == 0) {
            this.attackTime = this.attackTimeBefore;
        }
    }
}

