/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.data;

import cn.nukkit.nbt.stream.FastByteArrayOutputStream;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.PersonaPiece;
import cn.nukkit.utils.PersonaPieceTint;
import cn.nukkit.utils.SerializedImage;
import cn.nukkit.utils.SkinAnimation;
import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;

public class Skin {
    private static final int PIXEL_SIZE = 4;
    public static final int SINGLE_SKIN_SIZE = 8192;
    public static final int DOUBLE_SKIN_SIZE = 16384;
    public static final int SKIN_128_64_SIZE = 32768;
    public static final int SKIN_128_128_SIZE = 65536;
    public static final String GEOMETRY_CUSTOM = Skin.convertLegacyGeometryName("geometry.humanoid.custom");
    public static final String GEOMETRY_CUSTOM_SLIM = Skin.convertLegacyGeometryName("geometry.humanoid.customSlim");
    private final String fullSkinId = UUID.randomUUID().toString();
    private String skinId;
    private String skinResourcePatch = GEOMETRY_CUSTOM;
    private SerializedImage skinData;
    private final List<SkinAnimation> animations = new ArrayList<SkinAnimation>();
    private final List<PersonaPiece> personaPieces = new ArrayList<PersonaPiece>();
    private final List<PersonaPieceTint> tintColors = new ArrayList<PersonaPieceTint>();
    private SerializedImage capeData;
    private String geometryData;
    private String animationData;
    private boolean premium;
    private boolean persona;
    private boolean capeOnClassic;
    private String capeId;
    private String skinColor = "#0";
    private String armSize = "wide";
    private boolean trusted = false;

    public boolean isValid() {
        return this.isValidSkin() && this.isValidResourcePatch();
    }

    private boolean isValidSkin() {
        return this.skinId != null && !this.skinId.trim().isEmpty() && this.skinData != null && this.skinData.width >= 64 && this.skinData.height >= 32 && this.skinData.data.length >= 8192;
    }

    private boolean isValidResourcePatch() {
        if (this.skinResourcePatch == null) {
            return false;
        }
        try {
            JSONObject object = (JSONObject)JSONValue.parse(this.skinResourcePatch);
            JSONObject geometry = (JSONObject)object.get("geometry");
            return geometry.containsKey("default") && geometry.get("default") instanceof String;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public SerializedImage getSkinData() {
        if (this.skinData == null) {
            return SerializedImage.EMPTY;
        }
        return this.skinData;
    }

    public String getSkinId() {
        if (this.skinId == null) {
            this.generateSkinId("Custom");
        }
        return this.skinId;
    }

    public void setSkinId(String skinId) {
        if (skinId == null || skinId.trim().isEmpty()) {
            return;
        }
        this.skinId = skinId;
    }

    public void generateSkinId(String name) {
        byte[] data = Binary.appendBytes(this.getSkinData().data, (byte[][])new byte[][]{this.getSkinResourcePatch().getBytes(StandardCharsets.UTF_8)});
        this.skinId = UUID.nameUUIDFromBytes(data) + "." + name;
    }

    public void setSkinData(byte[] skinData) {
        this.setSkinData(SerializedImage.fromLegacy(skinData));
    }

    public void setSkinData(BufferedImage image) {
        this.setSkinData(Skin.parseBufferedImage(image));
    }

    public void setSkinData(SerializedImage skinData) {
        Objects.requireNonNull(skinData, "skinData");
        this.skinData = skinData;
    }

    public void setSkinResourcePatch(String skinResourcePatch) {
        if (skinResourcePatch == null || skinResourcePatch.trim().isEmpty()) {
            skinResourcePatch = GEOMETRY_CUSTOM;
        }
        this.skinResourcePatch = skinResourcePatch;
    }

    public void setGeometryName(String geometryName) {
        if (geometryName == null || geometryName.trim().isEmpty()) {
            this.skinResourcePatch = GEOMETRY_CUSTOM;
            return;
        }
        this.skinResourcePatch = "{\"geometry\" : {\"default\" : \"" + geometryName + "\"}}";
    }

    public String getSkinResourcePatch() {
        if (this.skinResourcePatch == null) {
            return "";
        }
        return this.skinResourcePatch;
    }

    public SerializedImage getCapeData() {
        if (this.capeData == null) {
            return SerializedImage.EMPTY;
        }
        return this.capeData;
    }

    public String getCapeId() {
        if (this.capeId == null) {
            return "";
        }
        return this.capeId;
    }

    public void setCapeId(String capeId) {
        if (capeId == null || capeId.trim().isEmpty()) {
            capeId = null;
        }
        this.capeId = capeId;
    }

    public void setCapeData(byte[] capeData) {
        Objects.requireNonNull(capeData, "capeData");
        Preconditions.checkArgument(capeData.length == 8192 || capeData.length == 0, "Invalid legacy cape");
        this.setCapeData(new SerializedImage(64, 32, capeData));
    }

    public void setCapeData(BufferedImage image) {
        this.setCapeData(Skin.parseBufferedImage(image));
    }

    public void setCapeData(SerializedImage capeData) {
        Objects.requireNonNull(capeData, "capeData");
        this.capeData = capeData;
    }

    public String getGeometryData() {
        if (this.geometryData == null) {
            return "";
        }
        return this.geometryData;
    }

    public void setGeometryData(String geometryData) {
        Preconditions.checkNotNull(geometryData, "geometryData");
        if (!geometryData.equals(this.geometryData)) {
            this.geometryData = geometryData;
        }
    }

    public String getAnimationData() {
        if (this.animationData == null) {
            return "";
        }
        return this.animationData;
    }

    public void setAnimationData(String animationData) {
        Preconditions.checkNotNull(animationData, "animationData");
        if (!animationData.equals(this.animationData)) {
            this.animationData = animationData;
        }
    }

    public List<SkinAnimation> getAnimations() {
        return this.animations;
    }

    public List<PersonaPiece> getPersonaPieces() {
        return this.personaPieces;
    }

    public List<PersonaPieceTint> getTintColors() {
        return this.tintColors;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public boolean isPersona() {
        return this.persona;
    }

    public void setPersona(boolean persona) {
        this.persona = persona;
    }

    public boolean isCapeOnClassic() {
        return this.capeOnClassic;
    }

    public void setCapeOnClassic(boolean capeOnClassic) {
        this.capeOnClassic = capeOnClassic;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getSkinColor() {
        return this.skinColor;
    }

    public void setSkinColor(String skinColor) {
        this.skinColor = skinColor;
    }

    public String getArmSize() {
        return this.armSize;
    }

    public void setArmSize(String armSize) {
        this.armSize = armSize;
    }

    public String getFullSkinId() {
        return this.fullSkinId;
    }

    private static SerializedImage parseBufferedImage(BufferedImage image) {
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color color = new Color(image.getRGB(x, y), true);
                outputStream.write(color.getRed());
                outputStream.write(color.getGreen());
                outputStream.write(color.getBlue());
                outputStream.write(color.getAlpha());
            }
        }
        image.flush();
        return new SerializedImage(image.getWidth(), image.getHeight(), outputStream.toByteArray());
    }

    private static String convertLegacyGeometryName(String geometryName) {
        return "{\"geometry\" : {\"default\" : \"" + geometryName + "\"}}";
    }

    public String toString() {
        return "Skin(fullSkinId=" + this.getFullSkinId() + ", skinId=" + this.getSkinId() + ", skinResourcePatch=" + this.getSkinResourcePatch() + ", skinData=" + this.getSkinData() + ", animations=" + this.getAnimations() + ", personaPieces=" + this.getPersonaPieces() + ", tintColors=" + this.getTintColors() + ", capeData=" + this.getCapeData() + ", premium=" + this.isPremium() + ", persona=" + this.isPersona() + ", capeOnClassic=" + this.isCapeOnClassic() + ", capeId=" + this.getCapeId() + ", skinColor=" + this.getSkinColor() + ", armSize=" + this.getArmSize() + ", trusted=" + this.isTrusted() + ")";
    }
}

