/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.EntityArmorInventory;
import cn.nukkit.inventory.EntityEquipmentInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArmor;
import cn.nukkit.item.ItemArmorStand;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.network.protocol.SetEntityDataPacket;
import cn.nukkit.scheduler.Task;
import java.util.Collection;

public class EntityArmorStand
extends EntityLiving
implements InventoryHolder {
    private EntityEquipmentInventory equipmentInventory;
    private EntityArmorInventory armorInventory;
    private static final String TAG_MAINHAND = "Mainhand";
    private static final String TAG_POSE_INDEX = "PoseIndex";
    private static final String TAG_OFFHAND = "Offhand";
    private static final String TAG_ARMOR = "Armor";
    private static final int DATA_FLAGS2 = 91;
    private int vibrateTimer = 0;

    @Override
    public int getNetworkId() {
        return 61;
    }

    public EntityArmorStand(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(6);
        this.setHealth(6.0f);
        this.setImmobile(true);
        super.initEntity();
        this.equipmentInventory = new EntityEquipmentInventory(this);
        this.armorInventory = new EntityArmorInventory(this);
        if (this.namedTag.contains(TAG_MAINHAND)) {
            this.equipmentInventory.setItemInHand(NBTIO.getItemHelper(this.namedTag.getCompound(TAG_MAINHAND)), true);
        }
        if (this.namedTag.contains(TAG_OFFHAND)) {
            this.equipmentInventory.setOffhandItem(NBTIO.getItemHelper(this.namedTag.getCompound(TAG_OFFHAND)), true);
        }
        if (this.namedTag.contains(TAG_ARMOR)) {
            ListTag<CompoundTag> armorList = this.namedTag.getList(TAG_ARMOR, CompoundTag.class);
            for (CompoundTag armorTag : armorList.getAll()) {
                this.armorInventory.setItem(armorTag.getByte("Slot"), NBTIO.getItemHelper(armorTag));
            }
        }
        if (this.namedTag.contains(TAG_POSE_INDEX)) {
            this.setPose(this.namedTag.getInt(TAG_POSE_INDEX));
        }
    }

    @Override
    public float getHeight() {
        return 1.975f;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (player.isSneaking()) {
            if (this.getPose() >= 12) {
                this.setPose(0);
            } else {
                this.setPose(this.getPose() + 1);
            }
            return true;
        }
        if (this.isValid() && !player.isSpectator()) {
            int i = 0;
            boolean flag = !item.isNull();
            boolean isArmorSlot = false;
            if (flag && item instanceof ItemArmor) {
                ItemArmor itemArmor = (ItemArmor)item;
                i = EntityArmorStand.getArmorSlot(itemArmor);
                isArmorSlot = true;
            }
            if (flag && item.getId() == 397 || item.getBlockId() == 86) {
                i = 0;
            }
            int j = 0;
            double d3 = clickedPos.y - this.y;
            boolean flag2 = false;
            if (d3 >= 0.1 && d3 < 0.55 && !this.armorInventory.getItem(3).isNull()) {
                j = 3;
                isArmorSlot = true;
                flag2 = true;
            } else if (d3 >= 0.9 && d3 < 1.6 && !this.armorInventory.getItem(1).isNull()) {
                j = 1;
                isArmorSlot = true;
                flag2 = true;
            } else if (d3 >= 0.4 && d3 < 1.2 && !this.armorInventory.getItem(2).isNull()) {
                j = 2;
                isArmorSlot = true;
                flag2 = true;
            } else if (d3 >= 1.6 && !this.armorInventory.getItem(0).isNull()) {
                isArmorSlot = true;
                flag2 = true;
            } else if (!this.equipmentInventory.getItem(j).isNull()) {
                flag2 = true;
            }
            if (flag) {
                this.tryChangeEquipment(player, item, i, isArmorSlot);
            } else if (flag2) {
                this.tryChangeEquipment(player, item, j, isArmorSlot);
            }
            this.equipmentInventory.sendContents(player);
            this.armorInventory.sendContents(player);
            return flag || flag2;
        }
        return false;
    }

    private void tryChangeEquipment(final Player player, Item handItem, int slot, boolean isArmorSlot) {
        Item item;
        Item item2 = item = isArmorSlot ? this.armorInventory.getItem(slot) : this.equipmentInventory.getItem(slot);
        if (player.isCreative() && item.isNull() && !handItem.isNull()) {
            Item itemClone = handItem.clone();
            itemClone.setCount(1);
            if (isArmorSlot) {
                this.armorInventory.setItem(slot, itemClone);
            } else {
                this.equipmentInventory.setItem(slot, itemClone);
            }
        } else if (!handItem.isNull() && handItem.getCount() > 1) {
            if (item.isNull()) {
                Item itemClone = handItem.clone();
                itemClone.setCount(1);
                if (isArmorSlot) {
                    this.armorInventory.setItem(slot, itemClone);
                } else {
                    this.equipmentInventory.setItem(slot, itemClone);
                }
                player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
            }
        } else {
            if (isArmorSlot) {
                this.armorInventory.setItem(slot, handItem);
            } else {
                this.equipmentInventory.setItem(slot, handItem);
            }
            final int index = player.getInventory().getHeldItemIndex();
            Server.getInstance().getScheduler().scheduleDelayedTask(new Task(){

                @Override
                public void onRun(int i) {
                    player.getInventory().decreaseCount(index);
                    player.getInventory().addItem(item);
                }
            }, 1);
        }
    }

    private int getPose() {
        return this.dataProperties.getInt(78);
    }

    private void setPose(int pose) {
        this.dataProperties.putInt(78, pose);
        SetEntityDataPacket setEntityDataPacket = new SetEntityDataPacket();
        setEntityDataPacket.eid = this.getId();
        setEntityDataPacket.metadata = this.getDataProperties();
        Server.getInstance().getOnlinePlayers().values().forEach(all -> all.dataPacket(setEntityDataPacket));
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.put(TAG_MAINHAND, NBTIO.putItemHelper(this.equipmentInventory.getItemInHand()));
        this.namedTag.put(TAG_OFFHAND, NBTIO.putItemHelper(this.equipmentInventory.getOffHandItem()));
        if (this.armorInventory != null) {
            ListTag<CompoundTag> armorTag = new ListTag<CompoundTag>(TAG_ARMOR);
            for (int i = 0; i < 4; ++i) {
                armorTag.add(NBTIO.putItemHelper(this.armorInventory.getItem(i), i));
            }
            this.namedTag.putList(armorTag);
        }
        this.namedTag.putInt(TAG_POSE_INDEX, this.getPose());
    }

    @Override
    public void spawnTo(Player player) {
        super.spawnTo(player);
        this.equipmentInventory.sendContents(player);
        this.armorInventory.sendContents(player);
    }

    @Override
    public void spawnToAll() {
        if (this.chunk != null && !this.closed) {
            Collection<Player> chunkPlayers = this.level.getChunkPlayers(this.chunk.getX(), this.chunk.getZ()).values();
            for (Player chunkPlayer : chunkPlayers) {
                this.spawnTo(chunkPlayer);
            }
        }
    }

    @Override
    public void fall(float fallDistance) {
        super.fall(fallDistance);
        this.level.addLevelSoundEvent(this, 1062);
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        EntityDamageByEntityEvent entityDamageByEntityEvent;
        Entity damager;
        if (source instanceof EntityDamageByEntityEvent && (damager = (entityDamageByEntityEvent = (EntityDamageByEntityEvent)source).getDamager()) instanceof Player) {
            Player damagerPlayer = (Player)damager;
            if (damagerPlayer.isCreative()) {
                this.level.addParticle(new DestroyBlockParticle(this, Block.get(5)));
                this.close();
                return true;
            }
            if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                this.level.dropItem(this, new ItemArmorStand());
                this.equipmentInventory.getContents().values().forEach(items -> this.level.dropItem(this, (Item)items));
                this.equipmentInventory.clearAll();
                this.armorInventory.getContents().values().forEach(items -> this.level.dropItem(this, (Item)items));
                this.armorInventory.clearAll();
            }
        }
        switch (source.getCause()) {
            case CONTACT: 
            case FALL: {
                source.setCancelled(true);
                break;
            }
        }
        super.attack(source);
        if (!source.isCancelled()) {
            this.level.addParticle(new DestroyBlockParticle(this, Block.get(5)));
            this.setGenericFlag(40, true);
            this.vibrateTimer = 20;
            this.close();
        }
        return false;
    }

    @Override
    public String getName() {
        return "ArmorStand";
    }

    private static int getArmorSlot(ItemArmor armorItem) {
        if (armorItem.isHelmet()) {
            return 0;
        }
        if (armorItem.isChestplate()) {
            return 1;
        }
        if (armorItem.isLeggings()) {
            return 2;
        }
        return 3;
    }

    @Override
    public boolean entityBaseTick(int tickDiff) {
        boolean hasUpdate = super.entityBaseTick(tickDiff);
        if (this.getGenericFlag(40) && this.vibrateTimer-- <= 0) {
            this.setGenericFlag(40, false);
        }
        return hasUpdate;
    }

    private void setGenericFlag(int propertyId, boolean value) {
        this.setDataFlag(propertyId >= 64 ? 91 : 0, propertyId % 64, value);
    }

    private boolean getGenericFlag(int propertyId) {
        return this.getDataFlag(propertyId >= 64 ? 91 : 0, propertyId % 64);
    }

    public EntityEquipmentInventory getEquipmentInventory() {
        return this.equipmentInventory;
    }

    @Override
    public EntityArmorInventory getInventory() {
        return this.armorInventory;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        int tickDiff = currentTick - this.lastUpdate;
        boolean hasUpdated = super.onUpdate(currentTick);
        if (this.closed || tickDiff <= 0 && !this.justCreated) {
            return hasUpdated;
        }
        this.timing.startTiming();
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive() && !this.onGround) {
            this.motionY -= (double)this.getGravity();
            this.move(this.motionX, this.motionY, this.motionZ);
            float friction = 1.0f - this.getDrag();
            this.motionX *= (double)friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= (double)friction;
            this.updateMovement();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }
}

