/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLava;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityBlockChangeEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class EntityFallingBlock
extends Entity {
    public static final int NETWORK_ID = 66;
    protected int blockId;
    protected int damage;
    protected boolean breakOnLava;

    @Override
    public float getWidth() {
        return 0.98f;
    }

    @Override
    public float getLength() {
        return 0.98f;
    }

    @Override
    public float getHeight() {
        return 0.98f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    protected float getBaseOffset() {
        return 0.49f;
    }

    @Override
    public boolean canCollide() {
        return false;
    }

    public EntityFallingBlock(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.namedTag != null) {
            if (this.namedTag.contains("TileID")) {
                this.blockId = this.namedTag.getInt("TileID");
            } else if (this.namedTag.contains("Tile")) {
                this.blockId = this.namedTag.getInt("Tile");
                this.namedTag.putInt("TileID", this.blockId);
            }
            if (this.namedTag.contains("Data")) {
                this.damage = this.namedTag.getByte("Data");
            }
        }
        this.breakOnLava = this.namedTag.getBoolean("BreakOnLava");
        if (this.blockId == 0) {
            this.close();
            return;
        }
        this.fireProof = true;
        this.setDataProperty(new IntEntityData(2, GlobalBlockPalette.getOrCreateRuntimeId(this.getBlock(), this.getDamage())));
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            this.motionY -= (double)this.getGravity();
            this.move(this.motionX, this.motionY, this.motionZ);
            float friction = 1.0f - this.getDrag();
            this.motionX *= (double)friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= (double)friction;
            Vector3 pos = new Vector3(this.x - 0.5, this.y, this.z - 0.5).round();
            if (this.breakOnLava && this.level.getBlock(pos.subtract(0.0, 1.0, 0.0)) instanceof BlockLava) {
                this.close();
                if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                    this.getLevel().dropItem(this, Block.get(this.getBlock(), this.getDamage()).toItem());
                }
                this.level.addParticle(new DestroyBlockParticle(pos, Block.get(this.getBlock(), this.getDamage())));
                return true;
            }
            if (this.onGround) {
                this.close();
                Block block = this.level.getBlock(pos);
                Vector3 floorPos = new Vector3(this.x - 0.5, this.y, this.z - 0.5).floor();
                Block floorBlock = this.level.getBlock(floorPos);
                if (this.getBlock() == 78 && floorBlock.getId() == 78 && (floorBlock.getDamage() & 7) != 7) {
                    int mergedHeight = (floorBlock.getDamage() & 7) + 1 + (this.getDamage() & 7) + 1;
                    if (mergedHeight > 8) {
                        EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(78, 7));
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            this.level.setBlock(floorPos, event.getTo(), true);
                            Vector3 abovePos = floorPos.up();
                            Block aboveBlock = this.level.getBlock(abovePos);
                            if (aboveBlock.getId() == 0) {
                                EntityBlockChangeEvent event2 = new EntityBlockChangeEvent(this, aboveBlock, Block.get(78, mergedHeight - 8 - 1));
                                this.server.getPluginManager().callEvent(event2);
                                if (!event2.isCancelled()) {
                                    this.level.setBlock(abovePos, event2.getTo(), true);
                                }
                            }
                        }
                    } else {
                        EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(78, mergedHeight - 1));
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            this.level.setBlock(floorPos, event.getTo(), true);
                        }
                    }
                } else if (block.getId() > 0 && block.isTransparent() && !block.canBeReplaced() || this.getBlock() == 78 && block instanceof BlockLiquid) {
                    if (this.getBlock() != 78 ? this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS) : this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
                        this.getLevel().dropItem(this, Block.get(this.getBlock(), this.getDamage()).toItem());
                    }
                } else {
                    EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, block, Block.get(this.getBlock(), this.getDamage()));
                    this.server.getPluginManager().callEvent(event);
                    if (!event.isCancelled()) {
                        this.getLevel().setBlock(pos, event.getTo(), true);
                        if (event.getTo().getId() == 145) {
                            this.getLevel().addLevelEvent(block, 1022);
                        }
                    }
                }
                hasUpdate = true;
            }
            this.updateMovement();
        }
        this.timing.stopTiming();
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    public int getBlock() {
        return this.blockId;
    }

    public int getDamage() {
        return this.damage;
    }

    @Override
    public int getNetworkId() {
        return 66;
    }

    @Override
    public void saveNBT() {
        this.namedTag.putInt("TileID", this.blockId);
        this.namedTag.putByte("Data", this.damage);
    }

    @Override
    public boolean canBeMovedByCurrents() {
        return false;
    }
}

