/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityExplosive;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityExplosionPrimeEvent;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Sound;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;

public class EntityPrimedTNT
extends Entity
implements EntityExplosive {
    public static final int NETWORK_ID = 65;
    protected int fuse;
    protected Entity source;

    @Override
    public float getWidth() {
        return 0.98f;
    }

    @Override
    public float getLength() {
        return 0.98f;
    }

    @Override
    public float getHeight() {
        return 0.98f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    protected float getBaseOffset() {
        return 0.49f;
    }

    @Override
    public boolean canCollide() {
        return false;
    }

    public EntityPrimedTNT(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityPrimedTNT(FullChunk chunk, CompoundTag nbt, Entity source) {
        super(chunk, nbt);
        this.source = source;
    }

    @Override
    public int getNetworkId() {
        return 65;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    @Override
    @PowerNukkitDifference(info="Using new method to play sounds", since="1.4.0.0-PN")
    protected void initEntity() {
        super.initEntity();
        this.fuse = this.namedTag.contains("Fuse") ? this.namedTag.getByte("Fuse") : 80;
        this.setDataFlag(0, 10, true);
        this.setDataProperty(new IntEntityData(55, this.fuse));
        this.getLevel().addSound(this, Sound.RANDOM_FIZZ);
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putByte("Fuse", this.fuse);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        if (this.fuse % 5 == 0) {
            this.setDataProperty(new IntEntityData(55, this.fuse));
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            this.motionY -= (double)this.getGravity();
            this.move(this.motionX, this.motionY, this.motionZ);
            float friction = 1.0f - this.getDrag();
            this.motionX *= (double)friction;
            this.motionY *= (double)friction;
            this.motionZ *= (double)friction;
            this.updateMovement();
            if (this.onGround) {
                this.motionY *= -0.5;
                this.motionX *= 0.7;
                this.motionZ *= 0.7;
            }
            this.fuse -= tickDiff;
            if (this.fuse <= 0) {
                if (this.level.getGameRules().getBoolean(GameRule.TNT_EXPLODES)) {
                    this.explode();
                }
                this.kill();
            }
        }
        this.timing.stopTiming();
        return hasUpdate || this.fuse >= 0 || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    public void explode() {
        EntityExplosionPrimeEvent event = new EntityExplosionPrimeEvent(this, 4.0);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        Explosion explosion = new Explosion(this, event.getForce(), this);
        if (event.isBlockBreaking()) {
            explosion.explodeA();
        }
        explosion.explodeB();
    }

    public Entity getSource() {
        return this.source;
    }
}

