/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.passive;

import cn.nukkit.Player;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockBeehive;
import cn.nukkit.block.BlockFlower;
import cn.nukkit.blockentity.BlockEntityBeehive;
import cn.nukkit.entity.passive.EntityAnimal;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.Arrays;
import java.util.Optional;

@Since(value="1.1.1.0-PN")
public class EntityBee
extends EntityAnimal {
    @Since(value="1.1.1.0-PN")
    public static final int NETWORK_ID = 122;
    private int beehiveTimer = 600;

    @Since(value="1.1.1.0-PN")
    public EntityBee(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 122;
    }

    @Override
    public float getWidth() {
        if (this.isBaby()) {
            return 0.35f;
        }
        return 0.7f;
    }

    @Override
    public float getHeight() {
        if (this.isBaby()) {
            return 0.3f;
        }
        return 0.6f;
    }

    @Since(value="1.1.1.0-PN")
    public boolean getHasNectar() {
        return false;
    }

    @Since(value="1.1.1.0-PN")
    public void setHasNectar(boolean hasNectar) {
    }

    @Since(value="1.1.1.0-PN")
    public boolean isAngry() {
        return false;
    }

    @Since(value="1.1.1.0-PN")
    public void setAngry(boolean angry) {
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (--this.beehiveTimer <= 0) {
            BlockEntityBeehive closestBeehive = null;
            double closestDistance = Double.MAX_VALUE;
            Optional<Block> flower = Arrays.stream(this.level.getCollisionBlocks(this.getBoundingBox().grow(4.0, 4.0, 4.0), false, true)).filter(block -> block instanceof BlockFlower).findFirst();
            for (Block collisionBlock : this.level.getCollisionBlocks(this.getBoundingBox().grow(1.5, 1.5, 1.5))) {
                double d;
                BlockEntityBeehive beehive;
                if (!(collisionBlock instanceof BlockBeehive) || (beehive = (BlockEntityBeehive)((BlockBeehive)collisionBlock).getOrCreateBlockEntity()).getOccupantsCount() >= 4) continue;
                double distance = beehive.distanceSquared(this);
                if (!(d < closestDistance)) continue;
                closestBeehive = beehive;
                closestDistance = distance;
            }
            if (closestBeehive != null) {
                BlockEntityBeehive.Occupant occupant = closestBeehive.addOccupant(this);
                if (flower.isPresent()) {
                    occupant.setTicksLeftToStay(2400);
                    occupant.setHasNectar(true);
                }
            }
        }
        return true;
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.setMaxHealth(10);
    }

    @Since(value="1.1.1.0-PN")
    public void nectarDelivered(BlockEntityBeehive blockEntityBeehive) {
    }

    @Since(value="1.1.1.0-PN")
    public void leftBeehive(BlockEntityBeehive blockEntityBeehive) {
    }

    @Since(value="1.1.1.0-PN")
    public void setAngry(Player player) {
    }
}

