/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.GenericParticle;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.DataPacket;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

public class EntitySnowball
extends EntityProjectile {
    public static final int NETWORK_ID = 81;
    private static final byte[] particleCounts = new byte[24];
    private static int particleIndex = 0;

    private static int nextParticleCount() {
        int index;
        if ((index = particleIndex++) >= particleCounts.length) {
            index = 0;
            particleIndex = 0;
        }
        return particleCounts[index];
    }

    @Override
    public int getNetworkId() {
        return 81;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }

    @Override
    protected float getGravity() {
        return 0.03f;
    }

    @Override
    protected float getDrag() {
        return 0.01f;
    }

    public EntitySnowball(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntitySnowball(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        this.timing.startTiming();
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.age > 1200 || this.isCollided) {
            this.kill();
            hasUpdate = true;
        }
        this.timing.stopTiming();
        return hasUpdate;
    }

    @Override
    protected void addHitEffect() {
        int particles = EntitySnowball.nextParticleCount();
        DataPacket[] particlePackets = new GenericParticle(this, 14).encode();
        int length = particlePackets.length;
        DataPacket[] allPackets = Arrays.copyOf(particlePackets, length * particles);
        for (int i = length; i < allPackets.length; ++i) {
            allPackets[i] = particlePackets[i % length];
        }
        int chunkX = (int)this.x >> 4;
        int chunkZ = (int)this.z >> 4;
        Level level = this.level;
        level.getServer().batchPackets(level.getChunkPlayers(chunkX, chunkZ).values().toArray(Player.EMPTY_ARRAY), allPackets);
    }

    static {
        for (int i = 0; i < particleCounts.length; ++i) {
            EntitySnowball.particleCounts[i] = (byte)(ThreadLocalRandom.current().nextInt(10) + 5);
        }
    }
}

