/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.player;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.command.CommandSender;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.player.PlayerMessageEvent;
import cn.nukkit.permission.Permissible;
import java.util.HashSet;
import java.util.Set;

public class PlayerChatEvent
extends PlayerMessageEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    protected String format;
    protected Set<CommandSender> recipients = new HashSet<CommandSender>();

    public static HandlerList getHandlers() {
        return handlers;
    }

    public PlayerChatEvent(Player player, String message) {
        this(player, message, "chat.type.text", null);
    }

    public PlayerChatEvent(Player player, String message, String format, Set<CommandSender> recipients) {
        this.player = player;
        this.message = message;
        this.format = format;
        if (recipients == null) {
            for (Permissible permissible : Server.getInstance().getPluginManager().getPermissionSubscriptions("nukkit.broadcast.user")) {
                if (!(permissible instanceof CommandSender)) continue;
                this.recipients.add((CommandSender)permissible);
            }
        } else {
            this.recipients = recipients;
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Set<CommandSender> getRecipients() {
        return this.recipients;
    }

    public void setRecipients(Set<CommandSender> recipients) {
        this.recipients = recipients;
    }
}

