/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.server;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.server.ServerEvent;
import cn.nukkit.nbt.stream.FastByteArrayOutputStream;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.PluginDescription;
import cn.nukkit.utils.Binary;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class QueryRegenerateEvent
extends ServerEvent {
    private static final HandlerList handlers = new HandlerList();
    private static final String GAME_ID = "MINECRAFTPE";
    private int timeout;
    private String serverName;
    private boolean listPlugins;
    private Plugin[] plugins;
    private Player[] players;
    private final String gameType;
    private final String version;
    private final String server_engine;
    private String map;
    private int numPlayers;
    private int maxPlayers;
    private final String whitelist;
    private final int port;
    private final String ip;
    private Map<String, String> extraData = new HashMap<String, String>();

    public static HandlerList getHandlers() {
        return handlers;
    }

    public QueryRegenerateEvent(Server server) {
        this(server, 5);
    }

    public QueryRegenerateEvent(Server server, int timeout) {
        this.timeout = timeout;
        this.serverName = server.getMotd();
        this.listPlugins = server.getConfig("settings.query-plugins", true);
        this.plugins = server.getPluginManager().getPlugins().values().toArray(Plugin.EMPTY_ARRAY);
        this.players = server.getOnlinePlayers().values().toArray(Player.EMPTY_ARRAY);
        this.gameType = (server.getGamemode() & 1) == 0 ? "SMP" : "CMP";
        this.version = server.getVersion();
        this.server_engine = server.getName() + " " + server.getNukkitVersion() + " (" + server.getGitCommit() + ")";
        this.map = server.getDefaultLevel() == null ? "unknown" : server.getDefaultLevel().getName();
        this.numPlayers = this.players.length;
        this.maxPlayers = server.getMaxPlayers();
        this.whitelist = server.hasWhitelist() ? "on" : "off";
        this.port = server.getPort();
        this.ip = server.getIp();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public boolean canListPlugins() {
        return this.listPlugins;
    }

    public void setListPlugins(boolean listPlugins) {
        this.listPlugins = listPlugins;
    }

    public Plugin[] getPlugins() {
        return this.plugins;
    }

    public void setPlugins(Plugin[] plugins) {
        this.plugins = plugins;
    }

    public Player[] getPlayerList() {
        return this.players;
    }

    public void setPlayerList(Player[] players) {
        this.players = players;
    }

    public int getPlayerCount() {
        return this.numPlayers;
    }

    public void setPlayerCount(int count) {
        this.numPlayers = count;
    }

    public int getMaxPlayerCount() {
        return this.maxPlayers;
    }

    public void setMaxPlayerCount(int count) {
        this.maxPlayers = count;
    }

    public String getWorld() {
        return this.map;
    }

    public void setWorld(String world) {
        this.map = world;
    }

    public Map<String, String> getExtraData() {
        return this.extraData;
    }

    public void setExtraData(Map<String, String> extraData) {
        this.extraData = extraData;
    }

    public byte[] getLongQuery(byte[] buffer) {
        if (buffer == null) {
            buffer = new byte[65535];
        }
        FastByteArrayOutputStream query = new FastByteArrayOutputStream(buffer);
        try {
            StringBuilder plist = new StringBuilder(this.server_engine);
            if (this.plugins.length > 0 && this.listPlugins) {
                plist.append(":");
                for (Plugin p : this.plugins) {
                    PluginDescription d = p.getDescription();
                    plist.append(" ").append(d.getName().replace(";", "").replace(":", "").replace(" ", "_")).append(" ").append(d.getVersion().replace(";", "").replace(":", "").replace(" ", "_")).append(";");
                }
                plist = new StringBuilder(plist.substring(0, plist.length() - 2));
            }
            query.write("splitnum".getBytes());
            query.write(0);
            query.write(-128);
            query.write(0);
            LinkedHashMap<String, String> KVdata = new LinkedHashMap<String, String>();
            KVdata.put("hostname", this.serverName);
            KVdata.put("gametype", this.gameType);
            KVdata.put("game_id", GAME_ID);
            KVdata.put("version", this.version);
            KVdata.put("server_engine", this.server_engine);
            KVdata.put("plugins", plist.toString());
            KVdata.put("map", this.map);
            KVdata.put("numplayers", String.valueOf(this.numPlayers));
            KVdata.put("maxplayers", String.valueOf(this.maxPlayers));
            KVdata.put("whitelist", this.whitelist);
            KVdata.put("hostip", this.ip);
            KVdata.put("hostport", String.valueOf(this.port));
            for (Map.Entry entry : KVdata.entrySet()) {
                query.write(((String)entry.getKey()).getBytes(StandardCharsets.UTF_8));
                query.write(0);
                query.write(((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
                query.write(0);
            }
            query.write(new byte[]{0, 1});
            query.write("player_".getBytes());
            query.write(new byte[]{0, 0});
            for (Player player : this.players) {
                query.write(player.getName().getBytes(StandardCharsets.UTF_8));
                query.write(0);
            }
            query.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return query.toByteArray();
    }

    public byte[] getShortQuery(byte[] buffer) {
        if (buffer == null) {
            buffer = new byte[65535];
        }
        FastByteArrayOutputStream query = new FastByteArrayOutputStream(buffer);
        try {
            query.write(this.serverName.getBytes(StandardCharsets.UTF_8));
            query.write(0);
            query.write(this.gameType.getBytes(StandardCharsets.UTF_8));
            query.write(0);
            query.write(this.map.getBytes(StandardCharsets.UTF_8));
            query.write(0);
            query.write(String.valueOf(this.numPlayers).getBytes(StandardCharsets.UTF_8));
            query.write(0);
            query.write(String.valueOf(this.maxPlayers).getBytes(StandardCharsets.UTF_8));
            query.write(0);
            query.write(Binary.writeLShort(this.port));
            query.write(this.ip.getBytes(StandardCharsets.UTF_8));
            query.write(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return query.toByteArray();
    }
}

