/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.inventory.FakeBlockUIComponent;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.enchantment.Enchantment;
import cn.nukkit.level.Position;
import cn.nukkit.nbt.tag.CompoundTag;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import lombok.NonNull;

public class AnvilInventory
extends FakeBlockUIComponent {
    public static final int OFFSET = 1;
    public static final int TARGET = 0;
    public static final int SACRIFICE = 1;
    public static final int RESULT = 50;
    private int levelCost;
    private String newItemName;
    @NonNull
    private Item currentResult = Item.get(0);

    public AnvilInventory(PlayerUIInventory playerUI, Position position) {
        super(playerUI, InventoryType.ANVIL, 1, position);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSlotChange(int index, Item before, boolean send) {
        try {
            if (index <= 1) {
                this.updateResult();
            }
        }
        finally {
            super.onSlotChange(index, before, send);
        }
    }

    public void updateResult() {
        Item target = this.getFirstItem();
        Item sacrifice = this.getSecondItem();
        if (target.isNull() && sacrifice.isNull()) {
            this.setResult(Item.get(0));
            this.setLevelCost(0);
            return;
        }
        this.setLevelCost(1);
        int extraCost = 0;
        int costHelper = 0;
        int repairMaterial = AnvilInventory.getRepairMaterial(target);
        Item result = target.clone();
        int levelCost = AnvilInventory.getRepairCost(result) + (sacrifice.isNull() ? 0 : AnvilInventory.getRepairCost(sacrifice));
        LinkedHashMap<Integer, Enchantment> enchantmentMap = new LinkedHashMap<Integer, Enchantment>();
        for (Enchantment enchantment : target.getEnchantments()) {
            enchantmentMap.put(enchantment.getId(), enchantment);
        }
        if (!sacrifice.isNull()) {
            int repair2;
            int repair;
            boolean enchantedBook;
            boolean bl = enchantedBook = sacrifice.getId() == 403 && sacrifice.getEnchantments().length > 0;
            if (result.getMaxDurability() != -1 && sacrifice.getId() == repairMaterial) {
                repair = Math.min(result.getDamage(), result.getMaxDurability() / 4);
                if (repair <= 0) {
                    this.setResult(Item.get(0));
                    this.setLevelCost(0);
                    return;
                }
                for (repair2 = 0; repair > 0 && repair2 < sacrifice.getCount(); ++repair2) {
                    int repair3 = result.getDamage() - repair;
                    result.setDamage(repair3);
                    ++extraCost;
                    repair = Math.min(result.getDamage(), result.getMaxDurability() / 4);
                }
            } else {
                if (!(enchantedBook || result.getId() == sacrifice.getId() && result.getMaxDurability() != -1)) {
                    this.setResult(Item.get(0));
                    this.setLevelCost(0);
                    return;
                }
                if (result.getMaxDurability() != -1 && !enchantedBook) {
                    repair = target.getMaxDurability() - target.getDamage();
                    repair2 = sacrifice.getMaxDurability() - sacrifice.getDamage();
                    int repair3 = repair2 + result.getMaxDurability() * 12 / 100;
                    int totalRepair = repair + repair3;
                    int finalDamage = result.getMaxDurability() - totalRepair + 1;
                    if (finalDamage < 0) {
                        finalDamage = 0;
                    }
                    if (finalDamage < result.getDamage()) {
                        result.setDamage(finalDamage);
                        extraCost += 2;
                    }
                }
                Enchantment[] sacrificeEnchantments = sacrifice.getEnchantments();
                boolean compatibleFlag = false;
                boolean incompatibleFlag = false;
                Iterator sacrificeEnchIter = Arrays.stream(sacrificeEnchantments).iterator();
                while (true) {
                    if (!sacrificeEnchIter.hasNext()) {
                        if (incompatibleFlag && !compatibleFlag) {
                            this.setResult(Item.get(0));
                            this.setLevelCost(0);
                            return;
                        }
                        break;
                    }
                    Enchantment sacrificeEnchantment = (Enchantment)sacrificeEnchIter.next();
                    if (sacrificeEnchantment == null) continue;
                    Enchantment resultEnchantment = result.getEnchantment(sacrificeEnchantment.id);
                    int targetLevel = resultEnchantment != null ? resultEnchantment.getLevel() : 0;
                    int resultLevel = sacrificeEnchantment.getLevel();
                    resultLevel = targetLevel == resultLevel ? resultLevel + 1 : Math.max(resultLevel, targetLevel);
                    boolean compatible = sacrificeEnchantment.isItemAcceptable(target);
                    if (this.playerUI.getHolder().isCreative() || target.getId() == 403) {
                        compatible = true;
                    }
                    Iterator targetEnchIter = Stream.of(target.getEnchantments()).iterator();
                    while (targetEnchIter.hasNext()) {
                        Enchantment targetEnchantment = (Enchantment)targetEnchIter.next();
                        if (targetEnchantment.id == sacrificeEnchantment.id || sacrificeEnchantment.isCompatibleWith(targetEnchantment) && targetEnchantment.isCompatibleWith(sacrificeEnchantment)) continue;
                        compatible = false;
                        ++extraCost;
                    }
                    if (!compatible) {
                        incompatibleFlag = true;
                        continue;
                    }
                    compatibleFlag = true;
                    if (resultLevel > sacrificeEnchantment.getMaxLevel()) {
                        resultLevel = sacrificeEnchantment.getMaxLevel();
                    }
                    enchantmentMap.put(sacrificeEnchantment.getId(), Enchantment.get(sacrificeEnchantment.getId()).setLevel(resultLevel));
                    int rarity = 0;
                    int weight = sacrificeEnchantment.getWeight();
                    rarity = weight >= 10 ? 1 : (weight >= 5 ? 2 : (weight >= 2 ? 4 : 8));
                    if (enchantedBook) {
                        rarity = Math.max(1, rarity / 2);
                    }
                    extraCost += rarity * Math.max(0, resultLevel - targetLevel);
                    if (target.getCount() <= 1) continue;
                    extraCost = 40;
                }
            }
        }
        if (StringUtil.isNullOrEmpty(this.newItemName)) {
            if (target.hasCustomName()) {
                costHelper = 1;
                extraCost += costHelper;
                result.clearCustomName();
            }
        } else {
            costHelper = 1;
            extraCost += costHelper;
            result.setCustomName(this.newItemName);
        }
        this.setLevelCost(levelCost + extraCost);
        if (extraCost <= 0) {
            result = Item.get(0);
        }
        if (costHelper == extraCost && costHelper > 0 && this.getLevelCost() >= 40) {
            this.setLevelCost(39);
        }
        if (this.getLevelCost() >= 40 && !this.playerUI.getHolder().isCreative()) {
            result = Item.get(0);
        }
        if (!result.isNull()) {
            CompoundTag namedTag;
            int repairCost = AnvilInventory.getRepairCost(result);
            if (!sacrifice.isNull() && repairCost < AnvilInventory.getRepairCost(sacrifice)) {
                repairCost = AnvilInventory.getRepairCost(sacrifice);
            }
            if (costHelper != extraCost || costHelper == 0) {
                repairCost = repairCost * 2 + 1;
            }
            if ((namedTag = result.getNamedTag()) == null) {
                namedTag = new CompoundTag();
            }
            namedTag.putInt("RepairCost", repairCost);
            namedTag.remove("ench");
            result.setNamedTag(namedTag);
            if (!enchantmentMap.isEmpty()) {
                result.addEnchantment(enchantmentMap.values().toArray(Enchantment.EMPTY_ARRAY));
            }
        }
        this.setResult(result);
    }

    @Override
    public void onClose(Player who) {
        super.onClose(who);
        who.craftingType = 0;
        Item[] drops = new Item[]{this.getFirstItem(), this.getSecondItem()};
        for (Item drop : drops = who.getInventory().addItem(drops)) {
            if (who.dropItem(drop)) continue;
            this.getHolder().getLevel().dropItem(this.getHolder().add(0.5, 0.5, 0.5), drop);
        }
        this.clear(0);
        this.clear(1);
        who.resetCraftingGridType();
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        who.craftingType = 2;
    }

    @Override
    public Item getItem(int index) {
        if (index < 0 || index > 3) {
            return Item.get(0);
        }
        if (index == 2) {
            return this.getResult();
        }
        return super.getItem(index);
    }

    @Override
    public boolean setItem(int index, Item item, boolean send) {
        if (index < 0 || index > 3) {
            return false;
        }
        if (index == 2) {
            return this.setResult(item);
        }
        return super.setItem(index, item, send);
    }

    public Item getFirstItem() {
        return this.getItem(0);
    }

    public Item getSecondItem() {
        return this.getItem(1);
    }

    public Item getResult() {
        return this.currentResult.clone();
    }

    @Override
    public void sendContents(Player ... players) {
        super.sendContents(players);
        for (Player player : players) {
            player.sendExperienceLevel();
        }
    }

    public boolean setFirstItem(Item item, boolean send) {
        return this.setItem(1, item, send);
    }

    public boolean setFirstItem(Item item) {
        return this.setFirstItem(item, true);
    }

    public boolean setSecondItem(Item item, boolean send) {
        return this.setItem(1, item, send);
    }

    public boolean setSecondItem(Item item) {
        return this.setSecondItem(item, true);
    }

    @Deprecated
    public boolean setResult(Item item, boolean send) {
        return this.setItem(2, item, send);
    }

    @Deprecated
    @DeprecationDetails(since="TBD", reason="the client won't see this change, and the transaction might fail", toBeRemovedAt="1.4.0.0-PN")
    public boolean setResult(Item item) {
        this.currentResult = item == null || item.isNull() ? Item.get(0) : item.clone();
        return true;
    }

    private static int getRepairCost(Item item) {
        return item.hasCompoundTag() && item.getNamedTag().contains("RepairCost") ? item.getNamedTag().getInt("RepairCost") : 0;
    }

    public int getLevelCost() {
        return this.levelCost;
    }

    protected void setLevelCost(int levelCost) {
        this.levelCost = levelCost;
    }

    public String getNewItemName() {
        return this.newItemName;
    }

    public void setNewItemName(String newItemName) {
        this.newItemName = newItemName;
    }

    private static int getRepairMaterial(Item target) {
        switch (target.getId()) {
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 290: {
                return 5;
            }
            case 256: 
            case 257: 
            case 258: 
            case 267: 
            case 292: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: {
                return 265;
            }
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 294: 
            case 314: 
            case 315: 
            case 316: 
            case 317: {
                return 266;
            }
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 293: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                return 264;
            }
            case 298: 
            case 299: 
            case 300: 
            case 301: {
                return 334;
            }
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 291: {
                return 4;
            }
            case 743: 
            case 744: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 749: 
            case 750: 
            case 751: {
                return 742;
            }
            case 444: {
                return 470;
            }
        }
        return 0;
    }
}

