/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.network.protocol.ContainerClosePacket;
import cn.nukkit.network.protocol.ContainerOpenPacket;
import java.util.Map;

public abstract class ContainerInventory
extends BaseInventory {
    public ContainerInventory(InventoryHolder holder, InventoryType type) {
        super(holder, type);
    }

    public ContainerInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items) {
        super(holder, type, items);
    }

    public ContainerInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items, Integer overrideSize) {
        super(holder, type, items, overrideSize);
    }

    public ContainerInventory(InventoryHolder holder, InventoryType type, Map<Integer, Item> items, Integer overrideSize, String overrideTitle) {
        super(holder, type, items, overrideSize, overrideTitle);
    }

    @Override
    public void onOpen(Player who) {
        super.onOpen(who);
        ContainerOpenPacket pk = new ContainerOpenPacket();
        pk.windowId = who.getWindowId(this);
        pk.type = this.getType().getNetworkType();
        InventoryHolder holder = this.getHolder();
        if (holder instanceof Vector3) {
            pk.x = (int)((Vector3)((Object)holder)).getX();
            pk.y = (int)((Vector3)((Object)holder)).getY();
            pk.z = (int)((Vector3)((Object)holder)).getZ();
        } else {
            pk.z = 0;
            pk.y = 0;
            pk.x = 0;
        }
        if (holder instanceof Entity) {
            pk.entityId = ((Entity)((Object)holder)).getId();
        }
        who.dataPacket(pk);
        this.sendContents(who);
    }

    @Override
    public void onClose(Player who) {
        ContainerClosePacket pk = new ContainerClosePacket();
        pk.windowId = who.getWindowId(this);
        pk.wasServerInitiated = false;
        who.dataPacket(pk);
        super.onClose(who);
    }

    public static int calculateRedstone(Inventory inv) {
        if (inv == null) {
            return 0;
        }
        int itemCount = 0;
        float averageCount = 0.0f;
        for (int slot = 0; slot < inv.getSize(); ++slot) {
            Item item = inv.getItem(slot);
            if (item.getId() == 0) continue;
            averageCount += (float)item.getCount() / (float)Math.min(inv.getMaxStackSize(), item.getMaxStackSize());
            ++itemCount;
        }
        return NukkitMath.floorFloat((averageCount /= (float)inv.getSize()) * 14.0f) + (itemCount > 0 ? 1 : 0);
    }
}

