/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.Server;
import cn.nukkit.inventory.BlastFurnaceRecipe;
import cn.nukkit.inventory.BrewingRecipe;
import cn.nukkit.inventory.CampfireRecipe;
import cn.nukkit.inventory.CartographyRecipe;
import cn.nukkit.inventory.ContainerRecipe;
import cn.nukkit.inventory.CraftingRecipe;
import cn.nukkit.inventory.FurnaceRecipe;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.ShapedRecipe;
import cn.nukkit.inventory.ShapelessRecipe;
import cn.nukkit.inventory.SmokerRecipe;
import cn.nukkit.inventory.StonecutterRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.network.protocol.BatchPacket;
import cn.nukkit.network.protocol.CraftingDataPacket;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.Config;
import cn.nukkit.utils.MainLogger;
import cn.nukkit.utils.Utils;
import io.netty.util.collection.CharObjectHashMap;
import io.netty.util.internal.EmptyArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingManager {
    private static final Logger log = LogManager.getLogger(CraftingManager.class);
    public final Collection<Recipe> recipes = new ArrayDeque<Recipe>();
    public static BatchPacket packet = null;
    protected final Map<Integer, Map<UUID, ShapedRecipe>> shapedRecipes = new Int2ObjectOpenHashMap<Map<UUID, ShapedRecipe>>();
    public final Map<Integer, FurnaceRecipe> furnaceRecipes = new Int2ObjectOpenHashMap<FurnaceRecipe>();
    public final Map<Integer, BlastFurnaceRecipe> blastFurnaceRecipes = new Int2ObjectOpenHashMap<BlastFurnaceRecipe>();
    public final Map<Integer, SmokerRecipe> smokerRecipes = new Int2ObjectOpenHashMap<SmokerRecipe>();
    public final Map<Integer, CampfireRecipe> campfireRecipes = new Int2ObjectOpenHashMap<CampfireRecipe>();
    public final Map<Integer, BrewingRecipe> brewingRecipes = new Int2ObjectOpenHashMap<BrewingRecipe>();
    public final Map<Integer, ContainerRecipe> containerRecipes = new Int2ObjectOpenHashMap<ContainerRecipe>();
    public final Map<Integer, StonecutterRecipe> stonecutterRecipes = new Int2ObjectOpenHashMap<StonecutterRecipe>();
    private static int RECIPE_COUNT = 0;
    protected final Map<Integer, Map<UUID, ShapelessRecipe>> shapelessRecipes = new Int2ObjectOpenHashMap<Map<UUID, ShapelessRecipe>>();
    protected final Map<Integer, Map<UUID, CartographyRecipe>> cartographyRecipes = new Int2ObjectOpenHashMap<Map<UUID, CartographyRecipe>>();
    public static final Comparator<Item> recipeComparator = (i1, i2) -> {
        if (i1.getId() > i2.getId()) {
            return 1;
        }
        if (i1.getId() < i2.getId()) {
            return -1;
        }
        if (i1.getDamage() > i2.getDamage()) {
            return 1;
        }
        if (i1.getDamage() < i2.getDamage()) {
            return -1;
        }
        return Integer.compare(i1.getCount(), i2.getCount());
    };

    public CraftingManager() {
        InputStream recipesStream = Server.class.getClassLoader().getResourceAsStream("recipes.json");
        if (recipesStream == null) {
            throw new AssertionError((Object)"Unable to find recipes.json");
        }
        Config recipesConfig = new Config(1);
        recipesConfig.load(recipesStream);
        this.loadRecipes(recipesConfig);
        String path = Server.getInstance().getDataPath() + "custom_recipes.json";
        File filePath = new File(path);
        if (filePath.exists()) {
            Config customRecipes = new Config(filePath, 1);
            this.loadRecipes(customRecipes);
        }
        this.rebuildPacket();
        MainLogger.getLogger().info("Loaded " + this.recipes.size() + " recipes.");
    }

    private void loadRecipes(Config config) {
        List<Map> recipes = config.getMapList("recipes");
        MainLogger.getLogger().info("Loading recipes...");
        for (Map map : recipes) {
            try {
                switch (Utils.toInt(map.get("type"))) {
                    case 0: {
                        List outputs;
                        String craftingBlock = (String)map.get("block");
                        if (!"crafting_table".equals(craftingBlock) && !"stonecutter".equals(craftingBlock) && !"cartography_table".equalsIgnoreCase(craftingBlock) || (outputs = (List)map.get("output")).size() > 1) break;
                        Map first = (Map)outputs.get(0);
                        ArrayList<Item> sorted = new ArrayList<Item>();
                        for (Map ingredient : (List)map.get("input")) {
                            sorted.add(Item.fromJson(ingredient));
                        }
                        sorted.sort(recipeComparator);
                        String recipeId = (String)map.get("id");
                        int priority = Utils.toInt(map.get("priority"));
                        switch (craftingBlock) {
                            case "crafting_table": {
                                this.registerRecipe(new ShapelessRecipe(recipeId, priority, Item.fromJson(first), sorted));
                                break;
                            }
                            case "stonecutter": {
                                this.registerRecipe(new StonecutterRecipe(recipeId, priority, Item.fromJson(first), (Item)sorted.get(0)));
                                break;
                            }
                            case "cartography_table": {
                                this.registerRecipe(new CartographyRecipe(recipeId, priority, Item.fromJson(first), sorted));
                            }
                        }
                        break;
                    }
                    case 1: {
                        String craftingBlock = (String)map.get("block");
                        if (!"crafting_table".equals(craftingBlock)) break;
                        List outputs = (List)map.get("output");
                        Map first = (Map)outputs.remove(0);
                        String[] shape = ((List)map.get("shape")).toArray(EmptyArrays.EMPTY_STRINGS);
                        CharObjectHashMap<Item> ingredients = new CharObjectHashMap<Item>();
                        ArrayList<Item> extraResults = new ArrayList<Item>();
                        Map input = (Map)map.get("input");
                        for (Map.Entry ingredientEntry : input.entrySet()) {
                            char ingredientChar = ((String)ingredientEntry.getKey()).charAt(0);
                            Item ingredient = Item.fromJson((Map)ingredientEntry.getValue());
                            ingredients.put(Character.valueOf(ingredientChar), ingredient);
                        }
                        for (Map data : outputs) {
                            extraResults.add(Item.fromJson(data));
                        }
                        String recipeId = (String)map.get("id");
                        int priority = Utils.toInt(map.get("priority"));
                        this.registerRecipe(new ShapedRecipe(recipeId, priority, Item.fromJson(first), shape, ingredients, extraResults));
                        break;
                    }
                    case 2: 
                    case 3: {
                        Item inputItem;
                        String craftingBlock = (String)map.get("block");
                        if (!"furnace".equals(craftingBlock) && !"blast_furnace".equals(craftingBlock) && !"smoker".equals(craftingBlock) && !"campfire".equals(craftingBlock)) break;
                        Map resultMap = (Map)map.get("output");
                        Item resultItem = Item.fromJson(resultMap);
                        try {
                            Map inputMap = (Map)map.get("input");
                            inputItem = Item.fromJson(inputMap);
                        }
                        catch (Exception old) {
                            inputItem = Item.get(Utils.toInt(map.get("inputId")), map.containsKey("inputDamage") ? Utils.toInt(map.get("inputDamage")) : -1, 1);
                        }
                        switch (craftingBlock) {
                            case "furnace": {
                                this.registerRecipe(new FurnaceRecipe(resultItem, inputItem));
                                break;
                            }
                            case "blast_furnace": {
                                this.registerRecipe(new BlastFurnaceRecipe(resultItem, inputItem));
                                break;
                            }
                            case "smoker": {
                                this.registerRecipe(new SmokerRecipe(resultItem, inputItem));
                                break;
                            }
                            case "campfire": {
                                this.registerRecipe(new CampfireRecipe(resultItem, inputItem));
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                MainLogger.getLogger().error("Exception during registering recipe", e);
            }
        }
        List<Map> potionMixes = config.getMapList("potionMixes");
        for (Map potionMix : potionMixes) {
            int fromPotionId = ((Number)potionMix.get("inputId")).intValue();
            int fromPotionMeta = ((Number)potionMix.get("inputMeta")).intValue();
            int ingredient = ((Number)potionMix.get("reagentId")).intValue();
            int ingredientMeta = ((Number)potionMix.get("reagentMeta")).intValue();
            int toPotionId = ((Number)potionMix.get("outputId")).intValue();
            int toPotionMeta = ((Number)potionMix.get("outputMeta")).intValue();
            this.registerBrewingRecipe(new BrewingRecipe(Item.get(fromPotionId, fromPotionMeta), Item.get(ingredient, ingredientMeta), Item.get(toPotionId, toPotionMeta)));
        }
        List<Map> list = config.getMapList("containerMixes");
        for (Map containerMix : list) {
            int fromItemId = ((Number)containerMix.get("inputId")).intValue();
            int ingredient = ((Number)containerMix.get("reagentId")).intValue();
            int toItemId = ((Number)containerMix.get("outputId")).intValue();
            this.registerContainerRecipe(new ContainerRecipe(Item.get(fromItemId), Item.get(ingredient), Item.get(toItemId)));
        }
        this.registerCartographyRecipe(new CartographyRecipe(Item.get(395), Collections.singletonList(Item.get(395))));
        this.registerCartographyRecipe(new CartographyRecipe(Item.get(395, 2), Collections.singletonList(Item.get(395, 2))));
        this.registerCartographyRecipe(new CartographyRecipe(Item.get(358), Collections.singletonList(Item.get(358))));
        this.registerCartographyRecipe(new CartographyRecipe(Item.get(358, 3), Collections.singletonList(Item.get(358, 3))));
        this.registerCartographyRecipe(new CartographyRecipe(Item.get(358, 4), Collections.singletonList(Item.get(358, 4))));
        this.registerCartographyRecipe(new CartographyRecipe(Item.get(358, 5), Collections.singletonList(Item.get(358, 5))));
    }

    public void rebuildPacket() {
        CraftingDataPacket pk = new CraftingDataPacket();
        pk.cleanRecipes = true;
        for (Recipe recipe : this.getRecipes()) {
            if (recipe instanceof ShapedRecipe) {
                pk.addShapedRecipe((ShapedRecipe)recipe);
                continue;
            }
            if (!(recipe instanceof ShapelessRecipe)) continue;
            pk.addShapelessRecipe((ShapelessRecipe)recipe);
        }
        for (Map map : this.cartographyRecipes.values()) {
            for (CartographyRecipe recipe : map.values()) {
                pk.addCartographyRecipe(recipe);
            }
        }
        for (FurnaceRecipe furnaceRecipe : this.getFurnaceRecipes().values()) {
            pk.addFurnaceRecipe(furnaceRecipe);
        }
        for (SmokerRecipe smokerRecipe : this.smokerRecipes.values()) {
            pk.addSmokerRecipe(smokerRecipe);
        }
        for (BlastFurnaceRecipe blastFurnaceRecipe : this.blastFurnaceRecipes.values()) {
            pk.addBlastFurnaceRecipe(blastFurnaceRecipe);
        }
        for (CampfireRecipe campfireRecipe : this.campfireRecipes.values()) {
            pk.addCampfireRecipeRecipe(campfireRecipe);
        }
        for (BrewingRecipe brewingRecipe : this.brewingRecipes.values()) {
            pk.addBrewingRecipe(brewingRecipe);
        }
        for (ContainerRecipe containerRecipe : this.containerRecipes.values()) {
            pk.addContainerRecipe(containerRecipe);
        }
        for (StonecutterRecipe stonecutterRecipe : this.stonecutterRecipes.values()) {
            pk.addStonecutterRecipe(stonecutterRecipe);
        }
        pk.encode();
        packet = pk.compress(9);
    }

    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }

    public Map<Integer, FurnaceRecipe> getFurnaceRecipes() {
        return this.furnaceRecipes;
    }

    public FurnaceRecipe matchFurnaceRecipe(Item input) {
        FurnaceRecipe recipe = this.furnaceRecipes.get(CraftingManager.getItemHash(input));
        if (recipe == null) {
            recipe = this.furnaceRecipes.get(CraftingManager.getItemHash(input.getId(), 0));
        }
        return recipe;
    }

    public CampfireRecipe matchCampfireRecipe(Item input) {
        CampfireRecipe recipe = this.campfireRecipes.get(CraftingManager.getItemHash(input));
        if (recipe == null) {
            recipe = this.campfireRecipes.get(CraftingManager.getItemHash(input.getId(), 0));
        }
        return recipe;
    }

    public BlastFurnaceRecipe matchBlastFurnaceRecipe(Item input) {
        BlastFurnaceRecipe recipe = this.blastFurnaceRecipes.get(CraftingManager.getItemHash(input));
        if (recipe == null) {
            recipe = this.blastFurnaceRecipes.get(CraftingManager.getItemHash(input.getId(), 0));
        }
        return recipe;
    }

    public SmokerRecipe matchSmokerRecipe(Item input) {
        SmokerRecipe recipe = this.smokerRecipes.get(CraftingManager.getItemHash(input));
        if (recipe == null) {
            recipe = this.smokerRecipes.get(CraftingManager.getItemHash(input.getId(), 0));
        }
        return recipe;
    }

    private static UUID getMultiItemHash(Collection<Item> items) {
        BinaryStream stream = new BinaryStream();
        for (Item item : items) {
            stream.putVarInt(CraftingManager.getFullItemHash(item));
        }
        return UUID.nameUUIDFromBytes(stream.getBuffer());
    }

    private static int getFullItemHash(Item item) {
        return 31 * CraftingManager.getItemHash(item) + item.getCount();
    }

    public void registerStonecutterRecipe(StonecutterRecipe recipe) {
        this.stonecutterRecipes.put(CraftingManager.getItemHash(recipe.getResult()), recipe);
    }

    public void registerFurnaceRecipe(FurnaceRecipe recipe) {
        Item input = recipe.getInput();
        this.furnaceRecipes.put(CraftingManager.getItemHash(input), recipe);
    }

    public void registerBlastFurnaceRecipe(BlastFurnaceRecipe recipe) {
        Item input = recipe.getInput();
        this.blastFurnaceRecipes.put(CraftingManager.getItemHash(input), recipe);
    }

    public void registerSmokerRecipe(SmokerRecipe recipe) {
        Item input = recipe.getInput();
        this.smokerRecipes.put(CraftingManager.getItemHash(input), recipe);
    }

    public void registerCampfireRecipe(CampfireRecipe recipe) {
        Item input = recipe.getInput();
        this.campfireRecipes.put(CraftingManager.getItemHash(input), recipe);
    }

    private static int getItemHash(Item item) {
        return CraftingManager.getItemHash(item.getId(), item.getDamage());
    }

    private static int getItemHash(int id, int meta) {
        return id << 8 | meta & 0xFF;
    }

    public void registerShapedRecipe(ShapedRecipe recipe) {
        int resultHash = CraftingManager.getItemHash(recipe.getResult());
        Map map = this.shapedRecipes.computeIfAbsent(resultHash, k -> new HashMap());
        LinkedList<Item> inputList = new LinkedList<Item>(recipe.getIngredientsAggregate());
        map.put(CraftingManager.getMultiItemHash(inputList), recipe);
    }

    public void registerRecipe(Recipe recipe) {
        UUID id = null;
        if (recipe instanceof CraftingRecipe || recipe instanceof StonecutterRecipe) {
            id = Utils.dataToUUID(String.valueOf(++RECIPE_COUNT), String.valueOf(recipe.getResult().getId()), String.valueOf(recipe.getResult().getDamage()), String.valueOf(recipe.getResult().getCount()), Arrays.toString(recipe.getResult().getCompoundTag()));
        }
        if (recipe instanceof CraftingRecipe) {
            ((CraftingRecipe)recipe).setId(id);
            this.recipes.add(recipe);
        } else if (recipe instanceof StonecutterRecipe) {
            ((StonecutterRecipe)recipe).setId(id);
        }
        recipe.registerToCraftingManager(this);
    }

    public void registerCartographyRecipe(CartographyRecipe recipe) {
        List<Item> list = recipe.getIngredientList();
        list.sort(recipeComparator);
        UUID hash = CraftingManager.getMultiItemHash(list);
        int resultHash = CraftingManager.getItemHash(recipe.getResult());
        Map map = this.cartographyRecipes.computeIfAbsent(resultHash, k -> new HashMap());
        map.put(hash, recipe);
    }

    public void registerShapelessRecipe(ShapelessRecipe recipe) {
        List<Item> list = recipe.getIngredientsAggregate();
        UUID hash = CraftingManager.getMultiItemHash(list);
        int resultHash = CraftingManager.getItemHash(recipe.getResult());
        Map map = this.shapelessRecipes.computeIfAbsent(resultHash, k -> new HashMap());
        map.put(hash, recipe);
    }

    private static int getPotionHash(Item ingredient, Item potion) {
        int ingredientHash = (ingredient.getId() & 0x3FF) << 6 | ingredient.getDamage() & 0x3F;
        int potionHash = (potion.getId() & 0x3FF) << 6 | potion.getDamage() & 0x3F;
        return ingredientHash << 16 | potionHash;
    }

    private static int getContainerHash(int ingredientId, int containerId) {
        return ingredientId << 9 | containerId;
    }

    public void registerBrewingRecipe(BrewingRecipe recipe) {
        Item potion;
        Item input = recipe.getIngredient();
        int potionHash = CraftingManager.getPotionHash(input, potion = recipe.getInput());
        if (this.brewingRecipes.containsKey(potionHash)) {
            log.warn("The brewing recipe " + this.brewingRecipes.get(potionHash) + " is being replaced by " + recipe);
        }
        this.brewingRecipes.put(potionHash, recipe);
    }

    public void registerContainerRecipe(ContainerRecipe recipe) {
        Item input = recipe.getIngredient();
        Item potion = recipe.getInput();
        this.containerRecipes.put(CraftingManager.getContainerHash(input.getId(), potion.getId()), recipe);
    }

    public BrewingRecipe matchBrewingRecipe(Item input, Item potion) {
        return this.brewingRecipes.get(CraftingManager.getPotionHash(input, potion));
    }

    public ContainerRecipe matchContainerRecipe(Item input, Item potion) {
        return this.containerRecipes.get(CraftingManager.getContainerHash(input.getId(), potion.getId()));
    }

    public StonecutterRecipe matchStonecutterRecipe(Item output) {
        return this.stonecutterRecipes.get(CraftingManager.getItemHash(output));
    }

    public CartographyRecipe matchCartographyRecipe(List<Item> inputList, Item primaryOutput, List<Item> extraOutputList) {
        int outputHash = CraftingManager.getItemHash(primaryOutput);
        if (this.cartographyRecipes.containsKey(outputHash)) {
            inputList.sort(recipeComparator);
            UUID inputHash = CraftingManager.getMultiItemHash(inputList);
            Map<UUID, CartographyRecipe> recipes = this.cartographyRecipes.get(outputHash);
            if (recipes == null) {
                return null;
            }
            CartographyRecipe recipe = recipes.get(inputHash);
            if (recipe != null && recipe.matchItems(inputList, extraOutputList) || this.matchItemsAccumulation(recipe, inputList, primaryOutput, extraOutputList)) {
                return recipe;
            }
            for (CartographyRecipe cartographyRecipe : recipes.values()) {
                if (!cartographyRecipe.matchItems(inputList, extraOutputList) && !this.matchItemsAccumulation(cartographyRecipe, inputList, primaryOutput, extraOutputList)) continue;
                return cartographyRecipe;
            }
        }
        return null;
    }

    public CraftingRecipe matchRecipe(List<Item> inputList, Item primaryOutput, List<Item> extraOutputList) {
        CraftingRecipe recipe;
        UUID inputHash;
        int outputHash = CraftingManager.getItemHash(primaryOutput);
        if (this.shapedRecipes.containsKey(outputHash)) {
            inputList.sort(recipeComparator);
            inputHash = CraftingManager.getMultiItemHash(inputList);
            Map<UUID, ShapedRecipe> recipeMap = this.shapedRecipes.get(outputHash);
            if (recipeMap != null) {
                recipe = recipeMap.get(inputHash);
                if (recipe != null && (((ShapedRecipe)recipe).matchItems(inputList, extraOutputList) || this.matchItemsAccumulation(recipe, inputList, primaryOutput, extraOutputList))) {
                    return recipe;
                }
                for (ShapedRecipe shapedRecipe : recipeMap.values()) {
                    if (!shapedRecipe.matchItems(inputList, extraOutputList) && !this.matchItemsAccumulation(shapedRecipe, inputList, primaryOutput, extraOutputList)) continue;
                    return shapedRecipe;
                }
            }
        }
        if (this.shapelessRecipes.containsKey(outputHash)) {
            inputList.sort(recipeComparator);
            inputHash = CraftingManager.getMultiItemHash(inputList);
            Map<UUID, ShapelessRecipe> recipes = this.shapelessRecipes.get(outputHash);
            if (recipes == null) {
                return null;
            }
            recipe = recipes.get(inputHash);
            if (recipe != null && (((ShapelessRecipe)recipe).matchItems(inputList, extraOutputList) || this.matchItemsAccumulation(recipe, inputList, primaryOutput, extraOutputList))) {
                return recipe;
            }
            for (ShapelessRecipe shapelessRecipe : recipes.values()) {
                if (!shapelessRecipe.matchItems(inputList, extraOutputList) && !this.matchItemsAccumulation(shapelessRecipe, inputList, primaryOutput, extraOutputList)) continue;
                return shapelessRecipe;
            }
        }
        return null;
    }

    private boolean matchItemsAccumulation(CraftingRecipe recipe, List<Item> inputList, Item primaryOutput, List<Item> extraOutputList) {
        Item recipeResult = recipe.getResult();
        if (primaryOutput.equals(recipeResult, recipeResult.hasMeta(), recipeResult.hasCompoundTag()) && primaryOutput.getCount() % recipeResult.getCount() == 0) {
            int multiplier = primaryOutput.getCount() / recipeResult.getCount();
            return recipe.matchItems(inputList, extraOutputList, multiplier);
        }
        return false;
    }

    public static class Entry {
        final int resultItemId;
        final int resultMeta;
        final int ingredientItemId;
        final int ingredientMeta;
        final String recipeShape;
        final int resultAmount;

        public Entry(int resultItemId, int resultMeta, int ingredientItemId, int ingredientMeta, String recipeShape, int resultAmount) {
            this.resultItemId = resultItemId;
            this.resultMeta = resultMeta;
            this.ingredientItemId = ingredientItemId;
            this.ingredientMeta = ingredientMeta;
            this.recipeShape = recipeShape;
            this.resultAmount = resultAmount;
        }
    }
}

