/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory;

import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.CraftingRecipe;
import cn.nukkit.inventory.RecipeType;
import cn.nukkit.item.Item;
import io.netty.util.collection.CharObjectHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;

public class ShapedRecipe
implements CraftingRecipe {
    private String recipeId;
    private final Item primaryResult;
    private final List<Item> extraResults = new ArrayList<Item>();
    private final List<Item> ingredientsAggregate;
    private long least;
    private long most;
    private final String[] shape;
    private final int priority;
    private final CharObjectHashMap<Item> ingredients = new CharObjectHashMap();

    public ShapedRecipe(Item primaryResult, String[] shape, Map<Character, Item> ingredients, List<Item> extraResults) {
        this(null, 1, primaryResult, shape, ingredients, extraResults);
    }

    public ShapedRecipe(String recipeId, int priority, Item primaryResult, String[] shape, Map<Character, Item> ingredients, List<Item> extraResults) {
        this.recipeId = recipeId;
        this.priority = priority;
        int rowCount = shape.length;
        if (rowCount > 3 || rowCount <= 0) {
            throw new RuntimeException("Shaped recipes may only have 1, 2 or 3 rows, not " + rowCount);
        }
        int columnCount = shape[0].length();
        if (columnCount > 3 || columnCount <= 0) {
            throw new RuntimeException("Shaped recipes may only have 1, 2 or 3 columns, not " + columnCount);
        }
        int shapeLength = shape.length;
        for (int i = 0; i < shapeLength; ++i) {
            String row = shape[i];
            if (row.length() != columnCount) {
                throw new RuntimeException("Shaped recipe rows must all have the same length (expected " + columnCount + ", got " + row.length() + ")");
            }
            for (int x = 0; x < columnCount; ++x) {
                char c = row.charAt(x);
                if (c == ' ' || ingredients.containsKey(Character.valueOf(c))) continue;
                throw new RuntimeException("No item specified for symbol '" + c + "'");
            }
            shape[i] = row.intern();
        }
        this.primaryResult = primaryResult.clone();
        this.extraResults.addAll(extraResults);
        this.shape = shape;
        for (Map.Entry<Character, Item> entry : ingredients.entrySet()) {
            this.setIngredient(entry.getKey().charValue(), entry.getValue());
        }
        this.ingredientsAggregate = new ArrayList<Item>();
        for (Object c : (Object)String.join((CharSequence)"", this.shape).toCharArray()) {
            if (c == 32) continue;
            Item ingredient = this.ingredients.get((char)c).clone();
            for (Item existingIngredient : this.ingredientsAggregate) {
                if (!existingIngredient.equals(ingredient, ingredient.hasMeta(), ingredient.hasCompoundTag())) continue;
                existingIngredient.setCount(existingIngredient.getCount() + ingredient.getCount());
                ingredient = null;
                break;
            }
            if (ingredient == null) continue;
            this.ingredientsAggregate.add(ingredient);
        }
        this.ingredientsAggregate.sort(CraftingManager.recipeComparator);
    }

    public int getWidth() {
        return this.shape[0].length();
    }

    public int getHeight() {
        return this.shape.length;
    }

    @Override
    public Item getResult() {
        return this.primaryResult;
    }

    @Override
    public String getRecipeId() {
        return this.recipeId;
    }

    @Override
    public UUID getId() {
        return new UUID(this.least, this.most);
    }

    @Override
    public void setId(UUID uuid) {
        this.least = uuid.getLeastSignificantBits();
        this.most = uuid.getMostSignificantBits();
        if (this.recipeId == null) {
            this.recipeId = this.getId().toString();
        }
    }

    public ShapedRecipe setIngredient(String key, Item item) {
        return this.setIngredient(key.charAt(0), item);
    }

    public ShapedRecipe setIngredient(char key, Item item) {
        if (String.join((CharSequence)"", this.shape).indexOf(key) < 0) {
            throw new RuntimeException("Symbol does not appear in the shape: " + key);
        }
        this.ingredients.put(key, item);
        return this;
    }

    public List<Item> getIngredientList() {
        ArrayList<Item> items = new ArrayList<Item>();
        int y2 = this.getHeight();
        for (int y = 0; y < y2; ++y) {
            int x2 = this.getWidth();
            for (int x = 0; x < x2; ++x) {
                items.add(this.getIngredient(x, y));
            }
        }
        return items;
    }

    public Map<Integer, Map<Integer, Item>> getIngredientMap() {
        LinkedHashMap<Integer, Map<Integer, Item>> ingredients = new LinkedHashMap<Integer, Map<Integer, Item>>();
        int y2 = this.getHeight();
        for (int y = 0; y < y2; ++y) {
            LinkedHashMap<Integer, Item> m = new LinkedHashMap<Integer, Item>();
            int x2 = this.getWidth();
            for (int x = 0; x < x2; ++x) {
                m.put(x, this.getIngredient(x, y));
            }
            ingredients.put(y, m);
        }
        return ingredients;
    }

    public Item getIngredient(int x, int y) {
        Item item = this.ingredients.get(this.shape[y].charAt(x));
        return item != null ? item.clone() : Item.get(0);
    }

    public String[] getShape() {
        return this.shape;
    }

    @Override
    public void registerToCraftingManager(CraftingManager manager) {
        manager.registerShapedRecipe(this);
    }

    @Override
    public RecipeType getType() {
        return RecipeType.SHAPED;
    }

    @Override
    public List<Item> getExtraResults() {
        return this.extraResults;
    }

    @Override
    public List<Item> getAllResults() {
        ArrayList<Item> list = new ArrayList<Item>();
        list.add(this.primaryResult);
        list.addAll(this.extraResults);
        return list;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public boolean matchItems(List<Item> inputList, List<Item> extraOutputList, int multiplier) {
        ArrayList<Item> haveInputs = new ArrayList<Item>();
        for (Item item : inputList) {
            if (item.isNull()) continue;
            haveInputs.add(item.clone());
        }
        ArrayList<Item> needInputs = new ArrayList<Item>();
        if (multiplier != 1) {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                Item itemClone = item.clone();
                itemClone.setCount(itemClone.getCount() * multiplier);
                needInputs.add(itemClone);
            }
        } else {
            for (Item item : this.ingredientsAggregate) {
                if (item.isNull()) continue;
                needInputs.add(item.clone());
            }
        }
        if (!this.matchItemList(haveInputs, needInputs)) {
            return false;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (Item item : extraOutputList) {
            if (item.isNull()) continue;
            arrayList.add(item.clone());
        }
        arrayList.sort(CraftingManager.recipeComparator);
        ArrayList<Item> arrayList2 = new ArrayList<Item>();
        if (multiplier != 1) {
            for (Item item : this.getExtraResults()) {
                if (item.isNull()) continue;
                Item itemClone = item.clone();
                itemClone.setCount(itemClone.getCount() * multiplier);
                arrayList2.add(itemClone);
            }
        } else {
            for (Item item : this.getExtraResults()) {
                if (item.isNull()) continue;
                arrayList2.add(item.clone());
            }
        }
        arrayList2.sort(CraftingManager.recipeComparator);
        return this.matchItemList(arrayList, arrayList2);
    }

    @Override
    public boolean matchItems(List<Item> inputList, List<Item> extraOutputList) {
        return this.matchItems(inputList, extraOutputList, 1);
    }

    private boolean matchItemList(List<Item> haveItems, List<Item> needItems) {
        block0: for (Item needItem : new ArrayList<Item>(needItems)) {
            for (Item haveItem : new ArrayList<Item>(haveItems)) {
                if (!needItem.equals(haveItem, needItem.hasMeta(), needItem.hasCompoundTag())) continue;
                int amount = Math.min(haveItem.getCount(), needItem.getCount());
                needItem.setCount(needItem.getCount() - amount);
                haveItem.setCount(haveItem.getCount() - amount);
                if (haveItem.getCount() == 0) {
                    haveItems.remove(haveItem);
                }
                if (needItem.getCount() != 0) continue;
                needItems.remove(needItem);
                continue block0;
            }
        }
        return haveItems.isEmpty() && needItems.isEmpty();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        this.ingredients.forEach((character, item) -> joiner.add(item.getName() + ":" + item.getDamage()));
        return joiner.toString();
    }

    @Override
    public boolean requiresCraftingTable() {
        return this.getHeight() > 2 || this.getWidth() > 2;
    }

    @Override
    public List<Item> getIngredientsAggregate() {
        return this.ingredientsAggregate;
    }

    public static class Entry {
        public final int x;
        public final int y;

        public Entry(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

