/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.event.inventory.CraftItemEvent;
import cn.nukkit.inventory.AnvilInventory;
import cn.nukkit.inventory.BigCraftingGrid;
import cn.nukkit.inventory.CraftingManager;
import cn.nukkit.inventory.GrindstoneInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.inventory.PlayerUIInventory;
import cn.nukkit.inventory.Recipe;
import cn.nukkit.inventory.RepairRecipe;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.DamageAnvilAction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.inventory.transaction.action.SlotChangeAction;
import cn.nukkit.inventory.transaction.action.TakeLevelAction;
import cn.nukkit.item.Item;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class CraftingTransaction
extends InventoryTransaction {
    protected int gridSize;
    protected List<Item> inputs;
    protected List<Item> secondaryOutputs;
    protected Item primaryOutput;
    protected Recipe recipe;
    protected int craftingType;
    private boolean readyToExecute;

    public CraftingTransaction(Player source, List<InventoryAction> actions) {
        super(source, actions, false);
        this.craftingType = source.craftingType;
        if (source.craftingType == 1001) {
            this.gridSize = 1;
            this.inputs = new ArrayList<Item>(1);
            this.secondaryOutputs = new ArrayList<Item>(1);
        } else {
            this.gridSize = source.getCraftingGrid() instanceof BigCraftingGrid ? 3 : 2;
            this.inputs = new ArrayList<Item>();
            this.secondaryOutputs = new ArrayList<Item>();
        }
        this.init(source, actions);
    }

    public void setInput(Item item) {
        if (this.inputs.size() < this.gridSize * this.gridSize) {
            for (Item existingInput : this.inputs) {
                if (!existingInput.equals(item, item.hasMeta(), item.hasCompoundTag())) continue;
                existingInput.setCount(existingInput.getCount() + item.getCount());
                return;
            }
        } else {
            throw new RuntimeException("Input list is full can't add " + item);
        }
        this.inputs.add(item.clone());
    }

    public List<Item> getInputList() {
        return this.inputs;
    }

    public void setExtraOutput(Item item) {
        if (this.secondaryOutputs.size() >= this.gridSize * this.gridSize) {
            throw new RuntimeException("Output list is full can't add " + item);
        }
        this.secondaryOutputs.add(item.clone());
    }

    public Item getPrimaryOutput() {
        return this.primaryOutput;
    }

    public void setPrimaryOutput(Item item) {
        if (this.primaryOutput == null) {
            this.primaryOutput = item.clone();
        } else if (!this.primaryOutput.equals(item)) {
            throw new RuntimeException("Primary result item has already been set and does not match the current item (expected " + this.primaryOutput + ", got " + item + ")");
        }
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    @Override
    public boolean canExecute() {
        CraftingManager craftingManager = this.source.getServer().getCraftingManager();
        if (this.craftingType == 1001) {
            this.recipe = craftingManager.matchStonecutterRecipe(this.primaryOutput);
        } else if (this.craftingType == 1002) {
            this.recipe = craftingManager.matchCartographyRecipe(this.inputs, this.primaryOutput, this.secondaryOutputs);
        } else if (this.craftingType == 2) {
            Inventory inventory = this.source.getWindowById(2);
            if (inventory instanceof AnvilInventory) {
                AnvilInventory anvil = (AnvilInventory)inventory;
                this.addInventory(anvil);
                if (this.primaryOutput.equalsIgnoringEnchantmentOrder(anvil.getResult(), true)) {
                    this.actions.removeIf(action -> action instanceof TakeLevelAction);
                    TakeLevelAction takeLevel = new TakeLevelAction(anvil.getLevelCost());
                    this.addAction(takeLevel);
                    if (takeLevel.isValid(this.source)) {
                        this.recipe = new RepairRecipe(InventoryType.ANVIL, this.primaryOutput, this.inputs);
                        PlayerUIInventory uiInventory = this.source.getUIInventory();
                        this.actions.add(new DamageAnvilAction(anvil, !this.source.isCreative() && ThreadLocalRandom.current().nextFloat() < 0.12f, this));
                        this.actions.stream().filter(a -> a instanceof SlotChangeAction).map(a -> (SlotChangeAction)a).filter(a -> a.getInventory() == uiInventory).filter(a -> a.getSlot() == 50).findFirst().ifPresent(a -> {
                            this.actions.remove(a);
                            this.actions.add(a);
                        });
                    }
                }
            }
            if (this.recipe == null) {
                this.source.sendExperienceLevel();
            }
            this.source.getUIInventory().setItem(50, Item.get(0), false);
        } else if (this.craftingType == 1000) {
            Inventory inventory = this.source.getWindowById(2);
            if (inventory instanceof GrindstoneInventory) {
                GrindstoneInventory grindstone = (GrindstoneInventory)inventory;
                this.addInventory(grindstone);
                if (grindstone.updateResult(false) && this.primaryOutput.equals(grindstone.getResult(), true, true)) {
                    this.recipe = new RepairRecipe(InventoryType.GRINDSTONE, this.primaryOutput, this.inputs);
                    grindstone.setResult(Item.get(0), false);
                }
            }
        } else {
            this.recipe = craftingManager.matchRecipe(this.inputs, this.primaryOutput, this.secondaryOutputs);
        }
        return this.recipe != null && super.canExecute();
    }

    @Override
    protected boolean callExecuteEvent() {
        CraftItemEvent ev = new CraftItemEvent(this);
        this.source.getServer().getPluginManager().callEvent(ev);
        return !ev.isCancelled();
    }

    @Override
    @PowerNukkitDifference(since="1.4.0.0-PN", info="No longer closes the inventory")
    protected void sendInventories() {
        super.sendInventories();
    }

    @Override
    public boolean execute() {
        if (super.execute()) {
            switch (this.primaryOutput.getId()) {
                case 58: {
                    this.source.awardAchievement("buildWorkBench");
                    break;
                }
                case 270: {
                    this.source.awardAchievement("buildPickaxe");
                    break;
                }
                case 61: {
                    this.source.awardAchievement("buildFurnace");
                    break;
                }
                case 290: {
                    this.source.awardAchievement("buildHoe");
                    break;
                }
                case 297: {
                    this.source.awardAchievement("makeBread");
                    break;
                }
                case 354: {
                    this.source.awardAchievement("bakeCake");
                    break;
                }
                case 257: 
                case 274: 
                case 278: 
                case 285: {
                    this.source.awardAchievement("buildBetterPickaxe");
                    break;
                }
                case 268: {
                    this.source.awardAchievement("buildSword");
                    break;
                }
                case 264: {
                    this.source.awardAchievement("diamond");
                }
            }
            return true;
        }
        return false;
    }

    @Since(value="1.3.0.0-PN")
    public boolean checkForCraftingPart(List<InventoryAction> actions) {
        for (InventoryAction action : actions) {
            SlotChangeAction slotChangeAction;
            if (!(action instanceof SlotChangeAction) || (slotChangeAction = (SlotChangeAction)action).getInventory().getType() != InventoryType.UI || slotChangeAction.getSlot() != 50 || slotChangeAction.getSourceItem().equals(slotChangeAction.getTargetItem())) continue;
            return true;
        }
        return false;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setReadyToExecute(boolean readyToExecute) {
        this.readyToExecute = readyToExecute;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isReadyToExecute() {
        return this.readyToExecute;
    }
}

