/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.inventory.transaction.action;

import cn.nukkit.Player;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.transaction.InventoryTransaction;
import cn.nukkit.inventory.transaction.action.InventoryAction;
import cn.nukkit.item.Item;
import java.util.HashSet;

public class SlotChangeAction
extends InventoryAction {
    protected Inventory inventory;
    private int inventorySlot;

    public SlotChangeAction(Inventory inventory, int inventorySlot, Item sourceItem, Item targetItem) {
        super(sourceItem, targetItem);
        this.inventory = inventory;
        this.inventorySlot = inventorySlot;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getSlot() {
        return this.inventorySlot;
    }

    @Override
    public boolean isValid(Player source) {
        Item check = this.inventory.getItem(this.inventorySlot);
        return check.equalsExact(this.sourceItem);
    }

    @Override
    public boolean execute(Player source) {
        return this.inventory.setItem(this.inventorySlot, this.targetItem, false);
    }

    @Override
    public void onExecuteSuccess(Player source) {
        HashSet<Player> viewers = new HashSet<Player>(this.inventory.getViewers());
        viewers.remove(source);
        this.inventory.sendSlot(this.inventorySlot, viewers);
    }

    @Override
    public void onExecuteFail(Player source) {
        this.inventory.sendSlot(this.inventorySlot, source);
    }

    @Override
    public void onAddToTransaction(InventoryTransaction transaction) {
        transaction.addInventory(this.inventory);
    }
}

