/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockUnknown;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.item.Item;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemBlock
extends Item {
    private static final Logger log = LogManager.getLogger(ItemBlock.class);

    public ItemBlock(Block block) {
        this(block, (Integer)0, 1);
    }

    public ItemBlock(Block block, Integer meta) {
        this(block, meta, 1);
    }

    public ItemBlock(Block block, Integer meta, int count) {
        super(block.getItemId(), meta, count, block.getName());
        this.block = block;
    }

    @Override
    public void setDamage(Integer meta) {
        int blockMeta;
        if (meta != null) {
            this.meta = meta;
            blockMeta = meta;
        } else {
            this.hasMeta = false;
            blockMeta = 0;
        }
        int blockId = this.block.getId();
        try {
            if (this.block instanceof BlockUnknown) {
                this.block = BlockState.of(blockId, blockMeta).getBlock();
                log.info("An invalid ItemBlock for " + this.block.getPersistenceName() + " was set to a valid meta " + meta + " and it is now safe again");
            } else {
                this.block.setDataStorageFromInt(blockMeta);
            }
        }
        catch (InvalidBlockStateException e) {
            log.warn("An ItemBlock for " + this.block.getPersistenceName() + " was set to have meta " + meta + " but this value is not valid. The item stack is now unsafe.", (Throwable)e);
            this.block = new BlockUnknown(blockId, (Integer)blockMeta);
            return;
        }
        int expected = this.block.asItemBlock().getDamage();
        if (expected != blockMeta) {
            log.warn("An invalid ItemBlock for " + this.block.getPersistenceName() + " was set to an valid meta " + meta + " for item blocks, it was expected to have meta " + expected + " the stack is now unsafe.\nProperties: " + this.block.getProperties());
        }
    }

    @Override
    public ItemBlock clone() {
        ItemBlock block = (ItemBlock)super.clone();
        block.block = this.block.clone();
        return block;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public boolean isLavaResistant() {
        return this.block.isLavaResistant();
    }
}

