/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.item.ItemArmor;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;

public abstract class ItemColorArmor
extends ItemArmor {
    public ItemColorArmor(int id) {
        super(id);
    }

    public ItemColorArmor(int id, Integer meta) {
        super(id, meta);
    }

    public ItemColorArmor(int id, Integer meta, int count) {
        super(id, meta, count);
    }

    public ItemColorArmor(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Deprecated
    public ItemColorArmor setColor(int dyeColor) {
        BlockColor blockColor = DyeColor.getByDyeData(dyeColor).getColor();
        return this.setColor(blockColor.getRed(), blockColor.getGreen(), blockColor.getBlue());
    }

    public ItemColorArmor setColor(DyeColor dyeColor) {
        BlockColor blockColor = dyeColor.getColor();
        return this.setColor(blockColor.getRed(), blockColor.getGreen(), blockColor.getBlue());
    }

    public ItemColorArmor setColor(BlockColor color) {
        return this.setColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    public ItemColorArmor setColor(int r, int g, int b) {
        int rgb = r << 16 | g << 8 | b;
        CompoundTag tag = this.hasCompoundTag() ? this.getNamedTag() : new CompoundTag();
        tag.putInt("customColor", rgb);
        this.setNamedTag(tag);
        return this;
    }

    public BlockColor getColor() {
        if (!this.hasCompoundTag()) {
            return null;
        }
        CompoundTag tag = this.getNamedTag();
        if (!tag.exist("customColor")) {
            return null;
        }
        int rgb = tag.getInt("customColor");
        return new BlockColor(rgb);
    }
}

