/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.item.Item;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.positiontracking.NamedPosition;
import java.io.IOException;
import javax.annotation.Nullable;

@PowerNukkitOnly
@Since(value="1.4.0.0-PN")
public class ItemCompassLodestone
extends Item {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ItemCompassLodestone() {
        this((Integer)0, 1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ItemCompassLodestone(Integer meta) {
        this(meta, 1);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ItemCompassLodestone(Integer meta, int count) {
        super(741, meta, count, "Lodestone Compass");
    }

    @Override
    public int getMaxStackSize() {
        return 1;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTrackingPosition(@Nullable NamedPosition position) throws IOException {
        if (position == null) {
            this.setTrackingHandle(0);
            return;
        }
        this.setTrackingHandle(Server.getInstance().getPositionTrackingService().addOrReusePosition(position));
    }

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public NamedPosition getTrackingPosition() throws IOException {
        int trackingHandle = this.getTrackingHandle();
        if (trackingHandle == 0) {
            return null;
        }
        return Server.getInstance().getPositionTrackingService().getPosition(trackingHandle);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public int getTrackingHandle() {
        return this.hasCompoundTag() ? this.getNamedTag().getInt("trackingHandle") : 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setTrackingHandle(int trackingHandle) {
        CompoundTag tag = this.getNamedTag();
        if (tag == null) {
            tag = new CompoundTag();
        }
        tag.putInt("trackingHandle", trackingHandle);
        this.setNamedTag(tag);
    }
}

