/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.item;

import cn.nukkit.Player;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.CreatureSpawnEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Random;

public class ItemSpawnEgg
extends Item {
    private static Int2IntMap newIds = new Int2IntOpenHashMap();

    public ItemSpawnEgg() {
        this((Integer)0, 1);
    }

    public ItemSpawnEgg(Integer meta) {
        this(meta, 1);
    }

    public ItemSpawnEgg(Integer meta, int count) {
        super(383, meta, count, "Spawn EntityEgg");
    }

    protected ItemSpawnEgg(int id, Integer meta, int count, String name) {
        super(id, meta, count, name);
    }

    @Override
    public boolean canBeActivated() {
        return true;
    }

    @Override
    public boolean onActivate(Level level, Player player, Block block, Block target, BlockFace face, double fx, double fy, double fz) {
        BaseFullChunk chunk = level.getChunk((int)block.getX() >> 4, (int)block.getZ() >> 4);
        if (chunk == null) {
            return false;
        }
        CompoundTag nbt = new CompoundTag().putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", block.getX() + 0.5)).add(new DoubleTag("", target.getBoundingBox() == null ? block.getY() : target.getBoundingBox().getMaxY() + (double)1.0E-4f)).add(new DoubleTag("", block.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", new Random().nextFloat() * 360.0f)).add(new FloatTag("", 0.0f)));
        if (this.hasCustomName()) {
            nbt.putString("CustomName", this.getCustomName());
        }
        int networkId = this.getEntityNetworkId();
        CreatureSpawnEvent ev = new CreatureSpawnEvent(networkId, block, nbt, CreatureSpawnEvent.SpawnReason.SPAWN_EGG);
        level.getServer().getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return false;
        }
        Entity entity = Entity.createEntity(networkId, (FullChunk)chunk, nbt, new Object[0]);
        if (entity != null) {
            if (player.isSurvival()) {
                player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
            }
            entity.spawnToAll();
            return true;
        }
        return false;
    }

    @Override
    @Since(value="1.3.2.0-PN")
    @PowerNukkitOnly
    public Item selfUpgrade() {
        if (this.getId() != 383) {
            return this;
        }
        int newId = newIds.getOrDefault(super.getDamage(), Integer.MIN_VALUE);
        if (newId == Integer.MIN_VALUE) {
            return this;
        }
        return Item.get(newId, 0, this.getCount(), this.getCompoundTag());
    }

    @PowerNukkitOnly
    @Since(value="1.3.2.0-PN")
    public int getEntityNetworkId() {
        return this.meta;
    }

    private static void registerNewIds() {
        newIds.put(56, 908);
        newIds.put(19, 865);
        newIds.put(122, 847);
        newIds.put(43, 842);
        newIds.put(75, 897);
        newIds.put(40, 862);
        newIds.put(10, 892);
        newIds.put(112, 848);
        newIds.put(11, 853);
        newIds.put(33, 901);
        newIds.put(31, 886);
        newIds.put(24, 887);
        newIds.put(110, 884);
        newIds.put(50, 835);
        newIds.put(38, 891);
        newIds.put(55, 808);
        newIds.put(104, 818);
        newIds.put(121, 850);
        newIds.put(41, 803);
        newIds.put(49, 898);
        newIds.put(124, 839);
        newIds.put(23, 902);
        newIds.put(47, 841);
        newIds.put(29, 849);
        newIds.put(42, 823);
        newIds.put(16, 873);
        newIds.put(25, 844);
        newIds.put(51, 854);
        newIds.put(22, 831);
        newIds.put(113, 829);
        newIds.put(30, 875);
        newIds.put(58, 838);
        newIds.put(12, 852);
        newIds.put(123, 871);
        newIds.put(127, 851);
        newIds.put(114, 861);
        newIds.put(28, 809);
        newIds.put(108, 874);
        newIds.put(18, 869);
        newIds.put(59, 904);
        newIds.put(109, 900);
        newIds.put(13, 881);
        newIds.put(54, 893);
        newIds.put(39, 830);
        newIds.put(34, 833);
        newIds.put(26, 880);
        newIds.put(37, 882);
        newIds.put(35, 867);
        newIds.put(17, 855);
        newIds.put(46, 816);
        newIds.put(125, 894);
        newIds.put(111, 824);
        newIds.put(74, 872);
        newIds.put(105, 825);
        newIds.put(15, 834);
        newIds.put(115, 834);
        newIds.put(57, 883);
        newIds.put(118, 827);
        newIds.put(45, 858);
        newIds.put(48, 819);
        newIds.put(14, 877);
        newIds.put(126, 805);
        newIds.put(32, 876);
        newIds.put(27, 846);
        newIds.put(36, 895);
        newIds.put(44, 815);
        newIds.put(116, 815);
    }

    static {
        ItemSpawnEgg.registerNewIds();
    }
}

