/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitDifference;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.entity.Entity;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import javax.annotation.Nullable;

public class MovingObjectPosition {
    public int typeOfHit;
    public int blockX;
    public int blockY;
    public int blockZ;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic numbers and not encapsulated", replaceWith="getFaceHit(), setFaceHit(BlockFace)")
    public int sideHit;
    public Vector3 hitVector;
    public Entity entityHit;

    @Nullable
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockFace getFaceHit() {
        switch (this.sideHit) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.EAST;
            }
            case 3: {
                return BlockFace.WEST;
            }
            case 4: {
                return BlockFace.NORTH;
            }
            case 5: {
                return BlockFace.SOUTH;
            }
        }
        return null;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setFaceHit(@Nullable BlockFace face) {
        if (face == null) {
            this.sideHit = -1;
            return;
        }
        switch (face) {
            case DOWN: {
                this.sideHit = 0;
                break;
            }
            case UP: {
                this.sideHit = 1;
                break;
            }
            case NORTH: {
                this.sideHit = 4;
                break;
            }
            case SOUTH: {
                this.sideHit = 5;
                break;
            }
            case WEST: {
                this.sideHit = 3;
                break;
            }
            case EAST: {
                this.sideHit = 2;
                break;
            }
            default: {
                this.sideHit = -1;
            }
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static MovingObjectPosition fromBlock(int x, int y, int z, BlockFace face, Vector3 hitVector) {
        MovingObjectPosition objectPosition = new MovingObjectPosition();
        objectPosition.typeOfHit = 0;
        objectPosition.blockX = x;
        objectPosition.blockY = y;
        objectPosition.blockZ = z;
        objectPosition.hitVector = new Vector3(hitVector.x, hitVector.y, hitVector.z);
        objectPosition.setFaceHit(face);
        return objectPosition;
    }

    @Deprecated
    @PowerNukkitDifference(since="1.4.0.0-PN", info="Fixed: sideHit not being filled")
    @DeprecationDetails(since="1.4.0.0-PN", reason="Magic number in side param", replaceWith="fromBlock(int,int,int,BlockFace,Vector3)")
    public static MovingObjectPosition fromBlock(int x, int y, int z, int side, Vector3 hitVector) {
        MovingObjectPosition objectPosition = new MovingObjectPosition();
        objectPosition.typeOfHit = 0;
        objectPosition.blockX = x;
        objectPosition.blockY = y;
        objectPosition.blockZ = z;
        objectPosition.sideHit = side;
        objectPosition.hitVector = new Vector3(hitVector.x, hitVector.y, hitVector.z);
        return objectPosition;
    }

    public static MovingObjectPosition fromEntity(Entity entity) {
        MovingObjectPosition objectPosition = new MovingObjectPosition();
        objectPosition.typeOfHit = 1;
        objectPosition.entityHit = entity;
        objectPosition.hitVector = new Vector3(entity.x, entity.y, entity.z);
        return objectPosition;
    }

    public String toString() {
        return "MovingObjectPosition{typeOfHit=" + this.typeOfHit + ", blockX=" + this.blockX + ", blockY=" + this.blockY + ", blockZ=" + this.blockZ + ", sideHit=" + this.sideHit + ", hitVector=" + this.hitVector + ", entityHit=" + this.entityHit + '}';
    }
}

