/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome;

import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.BlockID;
import cn.nukkit.level.ChunkManager;
import cn.nukkit.level.biome.EnumBiome;
import cn.nukkit.level.format.generic.BaseFullChunk;
import cn.nukkit.level.generator.populator.type.Populator;
import cn.nukkit.math.NukkitRandom;
import java.util.ArrayList;
import java.util.List;

public abstract class Biome
implements BlockID {
    public static final int MAX_BIOMES = 256;
    public static final Biome[] biomes = new Biome[256];
    public static final List<Biome> unorderedBiomes = new ArrayList<Biome>();
    private final ArrayList<Populator> populators = new ArrayList();
    private int id;
    private float baseHeight = 0.1f;
    private float heightVariation = 0.3f;

    protected static void register(int id, Biome biome) {
        biome.setId(id);
        Biome.biomes[id] = biome;
        unorderedBiomes.add(biome);
    }

    public static Biome getBiome(int id) {
        Biome biome = biomes[id];
        return biome != null ? biome : EnumBiome.OCEAN.biome;
    }

    public static Biome getBiome(String name) {
        for (Biome biome : biomes) {
            if (biome == null || !biome.getName().equalsIgnoreCase(name.replace("_", " "))) continue;
            return biome;
        }
        return null;
    }

    public void clearPopulators() {
        this.populators.clear();
    }

    public void addPopulator(Populator populator) {
        this.populators.add(populator);
    }

    public void populateChunk(ChunkManager level, int chunkX, int chunkZ, NukkitRandom random) {
        BaseFullChunk chunk = level.getChunk(chunkX, chunkZ);
        for (Populator populator : this.populators) {
            populator.populate(level, chunkX, chunkZ, random, chunk);
        }
    }

    public ArrayList<Populator> getPopulators() {
        return this.populators;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public abstract String getName();

    public void setBaseHeight(float baseHeight) {
        this.baseHeight = baseHeight;
    }

    public void setHeightVariation(float heightVariation) {
        this.heightVariation = heightVariation;
    }

    public float getBaseHeight() {
        return this.baseHeight;
    }

    public float getHeightVariation() {
        return this.heightVariation;
    }

    public int hashCode() {
        return this.getId();
    }

    public boolean equals(Object obj) {
        return this.hashCode() == obj.hashCode();
    }

    public boolean isFreezing() {
        return false;
    }

    public boolean doesOverhang() {
        return false;
    }

    public int getHeightOffset(int x, int z) {
        return 0;
    }

    public boolean canRain() {
        return true;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isDry() {
        return false;
    }
}

