/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.impl.extremehills;

import cn.nukkit.api.RemovedFromNewRakNet;
import cn.nukkit.api.Since;
import cn.nukkit.level.biome.type.CoveredBiome;

public class StoneBeachBiome
extends CoveredBiome {
    public StoneBeachBiome() {
        this.setBaseHeight(0.1f);
        this.setHeightVariation(0.8f);
    }

    @Override
    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getSurfaceDepth(int y) {
        if (this.useNewRakNetSurfaceDepth()) {
            return this.getSurfaceDepth(0, y, 0);
        }
        return 0;
    }

    @Override
    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getSurfaceBlock(int y) {
        if (this.useNewRakNetSurface()) {
            return this.getSurfaceId(0, y, 0) >> 4;
        }
        return 0;
    }

    @Override
    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getGroundDepth(int y) {
        if (this.useNewRakNetGroundDepth()) {
            return this.getGroundDepth(0, y, 0);
        }
        return 0;
    }

    @Override
    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getGroundBlock(int y) {
        if (this.useNewRakNetGround()) {
            return this.getGroundId(0, y, 0) >> 4;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "Stone Beach";
    }
}

