/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.biome.type;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.NewRakNetOnly;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.RemovedFromNewRakNet;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.FullChunk;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class CoveredBiome
extends Biome {
    private static final BlockState STATE_STONE = BlockState.of(1);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected Boolean useNewRakNetCover;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected Boolean useNewRakNetSurfaceDepth;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected Boolean useNewRakNetSurface;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected Boolean useNewRakNetGroundDepth;
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected Boolean useNewRakNetGroundBlock;
    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="Exposed lock object and removed from new-raknet and not used by PowerNukkit")
    @Since(value="1.4.0.0-PN")
    @RemovedFromNewRakNet
    public final Object synchronizeCover = new Object();

    @NewRakNetOnly
    public int getCoverId(int x, int z) {
        this.useNewRakNetCover = false;
        return this.getCoverBlock() << 4;
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getCoverBlock() {
        if (this.useNewRakNetCover()) {
            return this.getCoverId(0, 0);
        }
        return 0;
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getCoverState(int x, int z) {
        if (this.useNewRakNetCover()) {
            int fullId = this.getCoverId(x, z);
            int blockId = fullId >> 4;
            int storage = fullId & 0xF;
            return BlockState.of(blockId, storage);
        }
        return BlockState.of(this.getCoverBlock());
    }

    @NewRakNetOnly
    public int getSurfaceDepth(int x, int y, int z) {
        this.useNewRakNetSurfaceDepth = false;
        return this.getSurfaceDepth(y);
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getSurfaceDepth(int y) {
        if (this.useNewRakNetSurfaceDepth()) {
            return this.getSurfaceDepth(0, y, 0);
        }
        return 1;
    }

    @NewRakNetOnly
    public int getSurfaceId(int x, int y, int z) {
        this.useNewRakNetSurface = false;
        return this.getSurfaceBlock(y) << 4 | this.getSurfaceMeta(y) & 0xF;
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getSurfaceBlock(int y) {
        if (this.useNewRakNetSurface()) {
            return this.getSurfaceId(0, y, 0) >> 4;
        }
        return 0;
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getSurfaceMeta(int y) {
        if (this.useNewRakNetSurface()) {
            return this.getSurfaceId(0, y, 0) & 0xF;
        }
        return 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getSurfaceState(int x, int y, int z) {
        if (this.useNewRakNetSurface()) {
            int fullId = this.getSurfaceId(x, y, z);
            int blockId = fullId >> 4;
            int storage = fullId & 0xF;
            return BlockState.of(blockId, storage);
        }
        return BlockState.of(this.getSurfaceBlock(y), this.getSurfaceMeta(y));
    }

    @NewRakNetOnly
    public int getGroundDepth(int x, int y, int z) {
        this.useNewRakNetGroundDepth = false;
        return this.getGroundDepth(y);
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getGroundDepth(int y) {
        if (this.useNewRakNetGroundDepth()) {
            return this.getGroundDepth(0, y, 0);
        }
        return 4;
    }

    @NewRakNetOnly
    public int getGroundId(int x, int y, int z) {
        this.useNewRakNetGroundBlock = false;
        return this.getGroundBlock(y) << 4 | this.getGroundMeta(y) & 0xF;
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getGroundBlock(int y) {
        if (this.useNewRakNetGround()) {
            return this.getGroundId(0, y, 0) >> 4;
        }
        return 0;
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getGroundMeta(int y) {
        if (this.useNewRakNetGround()) {
            return this.getGroundId(0, y, 0) & 0xF;
        }
        return 0;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getGroundState(int x, int y, int z) {
        if (this.useNewRakNetGround()) {
            int fullId = this.getGroundId(x, y, z);
            int blockId = fullId >> 4;
            int storage = fullId & 0xF;
            return BlockState.of(blockId, storage);
        }
        return BlockState.of(this.getGroundBlock(y), this.getGroundMeta(y));
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public int getStoneBlock() {
        return 1;
    }

    @RemovedFromNewRakNet
    @Since(value="1.4.0.0-PN")
    public void preCover(int x, int z) {
    }

    @NewRakNetOnly
    public void doCover(int x, int z, @Nonnull FullChunk chunk) {
        int fullX = chunk.getX() << 4 | x;
        int fullZ = chunk.getZ() << 4 | z;
        this.preCover(fullX, fullZ);
        BlockState coverState = this.getCoverState(fullX, fullZ);
        boolean hasCovered = false;
        for (int y = 254; y > 32; --y) {
            if (chunk.getBlockState(x, y, z).equals(STATE_STONE)) {
                block8: {
                    if (!hasCovered) {
                        int realY;
                        int i;
                        if (y >= 64) {
                            chunk.setBlockState(x, y + 1, z, coverState);
                            int surfaceDepth = this.getSurfaceDepth(fullX, y, fullZ);
                            for (i = 0; i < surfaceDepth; ++i) {
                                realY = y - i;
                                if (chunk.getBlockState(x, realY, z).equals(STATE_STONE)) {
                                    chunk.setBlockState(x, realY, z, this.getSurfaceState(fullX, realY, fullZ));
                                    continue;
                                }
                                break block8;
                            }
                            y -= surfaceDepth;
                        }
                        int groundDepth = this.getGroundDepth(fullX, y, fullZ);
                        for (i = 0; i < groundDepth; ++i) {
                            realY = y - i;
                            if (chunk.getBlockState(x, realY, z).equals(STATE_STONE)) {
                                chunk.setBlockState(x, realY, z, this.getGroundState(fullX, realY, fullZ));
                                continue;
                            }
                            break block8;
                        }
                        y -= groundDepth - 1;
                    }
                }
                hasCovered = true;
                continue;
            }
            if (!hasCovered) continue;
            hasCovered = false;
        }
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean useNewRakNetCover() {
        Boolean useNewRakNet = this.useNewRakNetCover;
        if (useNewRakNet != null) {
            return useNewRakNet;
        }
        return this.attemptToUseNewRakNet(() -> this.getCoverId(0, 0), () -> this.useNewRakNetCover, val -> {
            this.useNewRakNetCover = val;
        });
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean useNewRakNetSurfaceDepth() {
        Boolean useNewRakNet = this.useNewRakNetSurfaceDepth;
        if (useNewRakNet != null) {
            return useNewRakNet;
        }
        return this.attemptToUseNewRakNet(() -> this.getSurfaceDepth(0, 0, 0), () -> this.useNewRakNetSurfaceDepth, val -> {
            this.useNewRakNetSurfaceDepth = val;
        });
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean useNewRakNetSurface() {
        Boolean useNewRakNet = this.useNewRakNetSurface;
        if (useNewRakNet != null) {
            return useNewRakNet;
        }
        return this.attemptToUseNewRakNet(() -> this.getSurfaceId(0, 0, 0), () -> this.useNewRakNetSurface, val -> {
            this.useNewRakNetSurface = val;
        });
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean useNewRakNetGroundDepth() {
        Boolean useNewRakNet = this.useNewRakNetGroundDepth;
        if (useNewRakNet != null) {
            return useNewRakNet;
        }
        return this.attemptToUseNewRakNet(() -> this.getGroundDepth(0, 0, 0), () -> this.useNewRakNetGroundDepth, val -> {
            this.useNewRakNetGroundDepth = val;
        });
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean useNewRakNetGround() {
        Boolean useNewRakNet = this.useNewRakNetGroundBlock;
        if (useNewRakNet != null) {
            return useNewRakNet;
        }
        return this.attemptToUseNewRakNet(() -> this.getGroundId(0, 0, 0), () -> this.useNewRakNetGroundBlock, val -> {
            this.useNewRakNetGroundBlock = val;
        });
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    protected boolean attemptToUseNewRakNet(Runnable method, Supplier<Boolean> flagGetter, Consumer<Boolean> flagSetter) {
        method.run();
        Boolean useNewRak = flagGetter.get();
        if (useNewRak != null) {
            return useNewRak;
        }
        flagSetter.accept(true);
        return true;
    }
}

