/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.entity.Entity;
import cn.nukkit.level.biome.Biome;
import cn.nukkit.level.format.LevelProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public interface FullChunk
extends Cloneable {
    public int getX();

    public int getZ();

    default public void setPosition(int x, int z) {
        this.setX(x);
        this.setZ(z);
    }

    public void setX(int var1);

    public void setZ(int var1);

    public long getIndex();

    public LevelProvider getProvider();

    public void setProvider(LevelProvider var1);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public int getFullBlock(int var1, int var2, int var3);

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public int getFullBlock(int var1, int var2, int var3, int var4);

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public int getBlockRuntimeId(int x, int y, int z) {
        return this.getBlockRuntimeId(x, y, z, 0);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    default public int getBlockRuntimeId(int x, int y, int z, int layer) {
        return this.getBlockState(x, y, z, layer).getRuntimeId();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getBlockState(int x, int y, int z) {
        return this.getBlockState(x, y, z, 0);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getBlockState(int x, int y, int z, int layer) {
        int full = this.getFullBlock(x, y, z, layer);
        return BlockState.of(full >> Block.DATA_BITS, full & Block.DATA_MASK);
    }

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="If the stored state is invalid, returns a BlockUnknown", replaceWith="getAndSetBlockState")
    public Block getAndSetBlock(int var1, int var2, int var3, Block var4);

    @Deprecated
    @DeprecationDetails(since="1.4.0.0-PN", reason="If the stored state is invalid, returns a BlockUnknown", replaceWith="getAndSetBlockState")
    @PowerNukkitOnly
    public Block getAndSetBlock(int var1, int var2, int var3, int var4, Block var5);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getAndSetBlockState(int var1, int var2, int var3, int var4, BlockState var5);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public BlockState getAndSetBlockState(int x, int y, int z, BlockState state) {
        return this.getAndSetBlockState(x, y, z, 0, state);
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN", replaceWith="setBlock(int x, int y, int z, int  blockId, int  meta)")
    default public boolean setFullBlockId(int x, int y, int z, int fullId) {
        return this.setFullBlockId(x, y, z, 0, fullId >> Block.DATA_BITS);
    }

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN", replaceWith="setBlockAtLayer(int x, int y, int z, int layer, int  blockId)")
    default public boolean setFullBlockId(int x, int y, int z, int layer, int fullId) {
        return this.setBlockAtLayer(x, y, z, layer, fullId >> Block.DATA_BITS, fullId & Block.DATA_MASK);
    }

    public boolean setBlock(int var1, int var2, int var3, int var4);

    @PowerNukkitOnly
    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5);

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    default public boolean setBlockState(int x, int y, int z, BlockState state) {
        return this.setBlockStateAtLayer(x, y, z, 0, state);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean setBlockStateAtLayer(int var1, int var2, int var3, int var4, BlockState var5);

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public boolean setBlock(int var1, int var2, int var3, int var4, int var5);

    @Deprecated
    @PowerNukkitOnly
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public boolean setBlockAtLayer(int var1, int var2, int var3, int var4, int var5, int var6);

    public int getBlockId(int var1, int var2, int var3);

    @PowerNukkitOnly
    public int getBlockId(int var1, int var2, int var3, int var4);

    public void setBlockId(int var1, int var2, int var3, int var4);

    @PowerNukkitOnly
    public void setBlockId(int var1, int var2, int var3, int var4, int var5);

    public int getBlockData(int var1, int var2, int var3);

    @PowerNukkitOnly
    public int getBlockData(int var1, int var2, int var3, int var4);

    public void setBlockData(int var1, int var2, int var3, int var4);

    @PowerNukkitOnly
    public void setBlockData(int var1, int var2, int var3, int var4, int var5);

    public int getBlockExtraData(int var1, int var2, int var3);

    public void setBlockExtraData(int var1, int var2, int var3, int var4);

    public int getBlockSkyLight(int var1, int var2, int var3);

    public void setBlockSkyLight(int var1, int var2, int var3, int var4);

    public int getBlockLight(int var1, int var2, int var3);

    public void setBlockLight(int var1, int var2, int var3, int var4);

    public int getHighestBlockAt(int var1, int var2);

    public int getHighestBlockAt(int var1, int var2, boolean var3);

    public int getHeightMap(int var1, int var2);

    public void setHeightMap(int var1, int var2, int var3);

    public void recalculateHeightMap();

    public int recalculateHeightMapColumn(int var1, int var2);

    public void populateSkyLight();

    public int getBiomeId(int var1, int var2);

    public void setBiomeId(int var1, int var2, byte var3);

    default public void setBiomeId(int x, int z, int biomeId) {
        this.setBiomeId(x, z, (byte)biomeId);
    }

    default public void setBiome(int x, int z, Biome biome) {
        this.setBiomeId(x, z, (byte)biome.getId());
    }

    public boolean isLightPopulated();

    public void setLightPopulated();

    public void setLightPopulated(boolean var1);

    public boolean isPopulated();

    public void setPopulated();

    public void setPopulated(boolean var1);

    public boolean isGenerated();

    public void setGenerated();

    public void setGenerated(boolean var1);

    public void addEntity(Entity var1);

    public void removeEntity(Entity var1);

    public void addBlockEntity(BlockEntity var1);

    public void removeBlockEntity(BlockEntity var1);

    public Map<Long, Entity> getEntities();

    public Map<Long, BlockEntity> getBlockEntities();

    public BlockEntity getTile(int var1, int var2, int var3);

    public boolean isLoaded();

    public boolean load() throws IOException;

    public boolean load(boolean var1) throws IOException;

    public boolean unload() throws Exception;

    public boolean unload(boolean var1) throws Exception;

    public boolean unload(boolean var1, boolean var2) throws Exception;

    public void initChunk();

    public byte[] getBiomeIdArray();

    public byte[] getHeightMapArray();

    public Map<Integer, Integer> getBlockExtraDataArray();

    public byte[] getBlockSkyLightArray();

    public byte[] getBlockLightArray();

    public byte[] toBinary();

    public byte[] toFastBinary();

    public boolean hasChanged();

    public void setChanged();

    public void setChanged(boolean var1);

    public boolean isBlockChangeAllowed(int var1, int var2, int var3);

    @Nonnull
    public List<Block> findBorders(int var1, int var2);

    public boolean isBlockedByBorder(int var1, int var2);
}

