/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format;

import cn.nukkit.Server;
import cn.nukkit.level.format.LevelProvider;
import java.util.HashMap;
import java.util.Map;

public abstract class LevelProviderManager {
    protected static final Map<String, Class<? extends LevelProvider>> providers = new HashMap<String, Class<? extends LevelProvider>>();

    public static void addProvider(Server server, Class<? extends LevelProvider> clazz) {
        try {
            providers.put((String)clazz.getMethod("getProviderName", new Class[0]).invoke(null, new Object[0]), clazz);
        }
        catch (Exception e) {
            Server.getInstance().getLogger().logException(e);
        }
    }

    public static Class<? extends LevelProvider> getProvider(String path) {
        for (Class<? extends LevelProvider> provider : providers.values()) {
            try {
                if (!((Boolean)provider.getMethod("isValid", String.class).invoke(null, path)).booleanValue()) continue;
                return provider;
            }
            catch (Exception e) {
                Server.getInstance().getLogger().logException(e);
            }
        }
        return null;
    }

    public static Class<? extends LevelProvider> getProviderByName(String name) {
        name = name.trim().toLowerCase();
        return providers.getOrDefault(name, null);
    }
}

