/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.palette;

import cn.nukkit.utils.ThreadCache;

public final class BitArray4096 {
    private final int bitsPerEntry;
    private final int maxSeqLocIndex;
    private final int maxEntryValue;
    private final long[] data;

    public BitArray4096(int bitsPerEntry) {
        this.bitsPerEntry = bitsPerEntry;
        this.maxSeqLocIndex = 64 - bitsPerEntry;
        this.maxEntryValue = (1 << bitsPerEntry) - 1;
        int longLen = this.bitsPerEntry * 4096 >> 6;
        this.data = new long[longLen];
    }

    public final void setAt(int index, int value) {
        if (this.data.length == 0) {
            return;
        }
        int bitIndexStart = index * this.bitsPerEntry;
        int longIndexStart = bitIndexStart >> 6;
        int localBitIndexStart = bitIndexStart & 0x3F;
        this.data[longIndexStart] = this.data[longIndexStart] & ((long)this.maxEntryValue << localBitIndexStart ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << localBitIndexStart;
        if (localBitIndexStart > this.maxSeqLocIndex) {
            int longIndexEnd = longIndexStart + 1;
            int localShiftStart = 64 - localBitIndexStart;
            int localShiftEnd = this.bitsPerEntry - localShiftStart;
            this.data[longIndexEnd] = this.data[longIndexEnd] >>> localShiftEnd << localShiftEnd | (long)value >> localShiftStart;
        }
    }

    public final int getAt(int index) {
        if (this.data.length == 0) {
            return 0;
        }
        int bitIndexStart = index * this.bitsPerEntry;
        int longIndexStart = bitIndexStart >> 6;
        int localBitIndexStart = bitIndexStart & 0x3F;
        if (localBitIndexStart <= this.maxSeqLocIndex) {
            return (int)(this.data[longIndexStart] >>> localBitIndexStart & (long)this.maxEntryValue);
        }
        int localShift = 64 - localBitIndexStart;
        return (int)((this.data[longIndexStart] >>> localBitIndexStart | this.data[longIndexStart + 1] << localShift) & (long)this.maxEntryValue);
    }

    public final void fromRawSlow(char[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            this.setAt(i, arr[i]);
        }
    }

    public final void fromRaw(char[] arr) {
        long[] data = this.data;
        int dataLength = data.length;
        int bitsPerEntry = this.bitsPerEntry;
        int maxEntryValue = this.maxEntryValue;
        int maxSeqLocIndex = this.maxSeqLocIndex;
        int localStart = 0;
        int arrI = 0;
        long l = 0L;
        for (int i = 0; i < dataLength; ++i) {
            char lastVal;
            while (localStart <= maxSeqLocIndex) {
                lastVal = arr[arrI++];
                l |= (long)lastVal << localStart;
                localStart += bitsPerEntry;
            }
            if (localStart < 64) {
                if (i == dataLength - 1) continue;
                lastVal = arr[arrI++];
                int shift = 64 - localStart;
                long nextVal = lastVal >> shift;
                data[i] = l |= (long)lastVal - (nextVal << shift) << localStart;
                data[i + 1] = l = nextVal;
                localStart -= maxSeqLocIndex;
                continue;
            }
            localStart = 0;
            data[i] = l;
            l = 0L;
        }
    }

    public BitArray4096 grow(int newBitsPerEntry) {
        int amtGrow = newBitsPerEntry - this.bitsPerEntry;
        if (amtGrow <= 0) {
            return this;
        }
        BitArray4096 newBitArray = new BitArray4096(newBitsPerEntry);
        char[] buffer = (char[])ThreadCache.charCache4096.get();
        this.toRaw(buffer);
        newBitArray.fromRaw(buffer);
        return newBitArray;
    }

    public BitArray4096 growSlow(int bitsPerEntry) {
        BitArray4096 newBitArray = new BitArray4096(bitsPerEntry);
        for (int i = 0; i < 4096; ++i) {
            newBitArray.setAt(i, this.getAt(i));
        }
        return newBitArray;
    }

    public final char[] toRawSlow() {
        char[] arr = new char[4096];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (char)this.getAt(i);
        }
        return arr;
    }

    public final char[] toRaw() {
        return this.toRaw(new char[4096]);
    }

    protected final char[] toRaw(char[] buffer) {
        long[] data = this.data;
        int dataLength = data.length;
        int bitsPerEntry = this.bitsPerEntry;
        int maxEntryValue = this.maxEntryValue;
        int maxSeqLocIndex = this.maxSeqLocIndex;
        int localStart = 0;
        int arrI = 0;
        for (int i = 0; i < dataLength; ++i) {
            char lastVal;
            long l = data[i];
            while (localStart <= maxSeqLocIndex) {
                lastVal = (char)(l >>> localStart & (long)maxEntryValue);
                buffer[arrI++] = lastVal;
                localStart += bitsPerEntry;
            }
            if (localStart < 64) {
                if (i == dataLength - 1) continue;
                lastVal = (char)(l >>> localStart);
                l = data[i + 1];
                int localShift = bitsPerEntry - (localStart -= maxSeqLocIndex);
                lastVal = (char)((long)lastVal | l << localShift);
                lastVal = (char)(lastVal & maxEntryValue);
                buffer[arrI++] = lastVal;
                continue;
            }
            localStart = 0;
        }
        return buffer;
    }
}

