/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.anvil.util;

import cn.nukkit.api.DeprecationDetails;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.block.Block;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.blockstate.BlockStateRegistry;
import cn.nukkit.blockstate.exception.InvalidBlockStateException;
import cn.nukkit.level.format.anvil.util.ImmutableBlockStorage;
import cn.nukkit.level.util.PalettedBlockStorage;
import cn.nukkit.utils.BinaryStream;
import cn.nukkit.utils.functional.BlockPositionDataConsumer;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.BitSet;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
public class BlockStorage {
    private static final Logger log = LogManager.getLogger(BlockStorage.class);
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static final BlockStorage[] EMPTY_ARRAY = new BlockStorage[0];
    private static final byte FLAG_HAS_ID = 1;
    private static final byte FLAG_HAS_ID_EXTRA = 2;
    private static final byte FLAG_HAS_DATA_EXTRA = 4;
    private static final byte FLAG_HAS_DATA_BIG = 8;
    private static final byte FLAG_HAS_DATA_HUGE = 16;
    private static final byte FLAG_PALETTE_UPDATED = 32;
    private static final byte FLAG_ENABLE_ID_EXTRA = 3;
    private static final byte FLAG_ENABLE_DATA_EXTRA = 5;
    private static final byte FLAG_ENABLE_DATA_BIG = 13;
    private static final byte FLAG_ENABLE_DATA_HUGE = 29;
    private static final byte FLAG_EVERYTHING_ENABLED = 63;
    private static final int BLOCK_ID_MASK = 255;
    private static final int BLOCK_ID_EXTRA_MASK = 65280;
    private static final int BLOCK_ID_FULL = 65535;
    public static final int SECTION_SIZE = 4096;
    private static final BlockState[] EMPTY = new BlockState[4096];
    private final PalettedBlockStorage palette;
    private final BlockState[] states;
    private byte flags = (byte)32;
    @Nullable
    private BitSet denyStates = null;

    public BlockStorage() {
        this.states = (BlockState[])EMPTY.clone();
        this.palette = new PalettedBlockStorage();
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    BlockStorage(BlockState[] states, byte flags, PalettedBlockStorage palette, @Nullable BitSet denyStates) {
        this.states = states;
        this.flags = flags;
        this.palette = palette;
        this.denyStates = denyStates;
    }

    private static int getIndex(int x, int y, int z) {
        int index = (x << 8) + (z << 4) + y;
        Preconditions.checkArgument(index >= 0 && index < 4096, "Invalid index");
        return index;
    }

    @Deprecated
    @Nonnegative
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public int getBlockData(int x, int y, int z) {
        return this.states[BlockStorage.getIndex(x, y, z)].getSignedBigDamage();
    }

    @Nonnegative
    public int getBlockId(int x, int y, int z) {
        return this.states[BlockStorage.getIndex(x, y, z)].getBlockId();
    }

    public void setBlockId(int x, int y, int z, @Nonnegative int id) {
        int index = BlockStorage.getIndex(x, y, z);
        this.setBlockState(index, this.states[index].withBlockId(id));
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    public void setBlockData(int x, int y, int z, @Nonnegative int data) {
        int index = BlockStorage.getIndex(x, y, z);
        this.setBlockState(index, this.states[index].withData(data));
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.4.0.0-PN")
    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public void setBlock(int x, int y, int z, @Nonnegative int id, @Nonnegative int data) {
        int index = BlockStorage.getIndex(x, y, z);
        BlockState state = BlockState.of(id, data);
        this.setBlockState(index, state);
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public int getFullBlock(int x, int y, int z) {
        return this.getFullBlock(BlockStorage.getIndex(x, y, z));
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    public void setFullBlock(int x, int y, int z, @Nonnegative int value) {
        this.setFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    @PowerNukkitOnly
    @Since(value="1.3.0.0-PN")
    public BlockState getAndSetBlock(int x, int y, int z, @Nonnegative int id, @Nonnegative int meta) {
        return this.setBlockState(BlockStorage.getIndex(x, y, z), BlockState.of(id, meta));
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getAndSetBlockState(int x, int y, int z, BlockState state) {
        return this.setBlockState(BlockStorage.getIndex(x, y, z), state);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void setBlockState(int x, int y, int z, BlockState state) {
        this.setBlockState(BlockStorage.getIndex(x, y, z), state);
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN", replaceWith="getAndSetFullBlock")
    public int getAndSetFullBlock(int x, int y, int z, int value) {
        return this.getAndSetFullBlock(BlockStorage.getIndex(x, y, z), value);
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    private int getAndSetFullBlock(int index, int value) {
        Preconditions.checkArgument(value < (511 << Block.DATA_BITS | Block.DATA_MASK), "Invalid full block");
        int blockId = value >> Block.DATA_BITS & 0xFFFF;
        int data = value & Block.DATA_MASK;
        BlockState newState = BlockState.of(blockId, data);
        BlockState oldState = this.states[index];
        if (oldState.equals(newState)) {
            return value;
        }
        this.setBlockState(index, newState);
        return oldState.getFullId();
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    private int getFullBlock(int index) {
        return this.states[index].getFullId();
    }

    @Deprecated
    @DeprecationDetails(reason="The meta is limited to 32 bits", since="1.3.0.0-PN")
    private void setFullBlock(int index, int value) {
        Preconditions.checkArgument(value < (65535 << Block.DATA_BITS | Block.DATA_MASK), "Invalid full block");
        int blockId = value >> Block.DATA_BITS & 0xFFFF;
        int data = value & Block.DATA_MASK;
        BlockState state = BlockState.of(blockId, data);
        this.setBlockState(index, state);
    }

    protected BlockState setBlockState(int index, BlockState state) {
        BlockState previous;
        if (log.isTraceEnabled() && !state.isCachedValidationValid()) {
            try {
                int runtimeId = state.getBlock().getRuntimeId();
                if (runtimeId == BlockStateRegistry.getFallbackRuntimeId()) {
                    log.trace("Setting a state that will become info update! State: {}", (Object)state, (Object)new RuntimeException());
                }
            }
            catch (InvalidBlockStateException e) {
                log.trace("Setting an invalid state! State: {}", (Object)state, (Object)e);
            }
        }
        if ((previous = this.states[index]).equals(state)) {
            return previous;
        }
        this.states[index] = state;
        this.updateFlags(index, previous, state);
        if (this.getFlag((byte)32)) {
            int runtimeId = state.getRuntimeId();
            if (runtimeId == BlockStateRegistry.getFallbackRuntimeId() && !state.equals(BlockStateRegistry.getFallbackBlockState())) {
                this.delayPaletteUpdates();
            } else {
                this.palette.setBlock(index, runtimeId);
            }
        }
        return previous;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public void delayPaletteUpdates() {
        this.setFlag((byte)32, false);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean isPaletteUpdateDelayed() {
        return !this.getFlag((byte)32);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public BlockState getBlockState(int x, int y, int z) {
        return this.states[BlockStorage.getIndex(x, y, z)];
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public void recheckBlocks() {
        this.flags = this.computeFlags((byte)(this.flags & 0x20), this.states);
    }

    private void updateFlags(int index, BlockState previous, BlockState state) {
        if (this.flags != 63) {
            this.flags = this.computeFlags(this.flags, state);
        }
        if (this.denyStates != null) {
            switch (previous.getBlockId()) {
                case 211: {
                    this.clearDeny(index);
                    break;
                }
                case 210: {
                    this.clearAllow(index);
                    break;
                }
                case 212: {
                    this.clearBorder(index);
                    break;
                }
            }
        }
        switch (state.getBlockId()) {
            case 211: {
                this.deny(index);
                break;
            }
            case 212: {
                this.border(index);
                break;
            }
            case 210: {
                this.allow(index);
                break;
            }
        }
    }

    private void border(int index) {
        if (this.denyStates == null) {
            this.denyStates = new BitSet();
        }
        index = (index & 0xFFFFFFF0) << 1;
        for (int y = 0; y <= 15; ++y) {
            this.denyStates.set(index++);
            this.denyStates.set(index++);
        }
    }

    private void deny(int index) {
        if (this.denyStates == null) {
            this.denyStates = new BitSet();
        }
        int y = index & 0xF;
        index <<= 1;
        boolean first = true;
        while (y <= 15) {
            if (this.denyStates.get(index + 1)) {
                if (first) {
                    if (this.denyStates.get(index)) {
                        return;
                    }
                    this.denyStates.clear(index + 1);
                } else {
                    if (this.states[index >> 1].getBlockId() == 210) {
                        return;
                    }
                    this.denyStates.clear(index + 1);
                }
            }
            this.denyStates.set(index);
            ++y;
            index += 2;
            first = false;
        }
    }

    private void allow(int index) {
        if (this.denyStates == null) {
            this.denyStates = new BitSet();
        }
        int y = index & 0xF;
        index <<= 1;
        boolean first = true;
        while (y <= 15) {
            if (this.denyStates.get(index)) {
                if (first) {
                    if (this.denyStates.get(index + 1)) {
                        return;
                    }
                    this.denyStates.clear(index);
                } else {
                    if (this.states[index >> 1].getBlockId() == 211) {
                        return;
                    }
                    this.denyStates.clear(index);
                }
            }
            this.denyStates.set(index + 1);
            ++y;
            index += 2;
            first = false;
        }
    }

    private void clearAllow(int index) {
        assert (this.denyStates != null);
        int y = index & 0xF;
        index <<= 1;
        while (y <= 15 && !this.denyStates.get(index)) {
            this.denyStates.clear(index + 1);
            ++y;
            index += 2;
            ++index;
        }
    }

    private void clearDeny(int index) {
        assert (this.denyStates != null);
        int y = index & 0xF;
        index <<= 1;
        while (y <= 15 && !this.denyStates.get(index + 1)) {
            this.denyStates.clear(index);
            ++y;
            index += 2;
            ++index;
        }
    }

    private void clearBorder(int index) {
        assert (this.denyStates != null);
        int bottomIndex = index & 0xFFFFFFF0;
        int topIndex = index | 0xF;
        for (int blockIndex = bottomIndex; blockIndex < topIndex; ++blockIndex) {
            if (this.states[blockIndex].getBlockId() != 212) continue;
            return;
        }
        boolean removeDeny = true;
        boolean removeAllow = true;
        int blockIndex = bottomIndex;
        int flagIndex = blockIndex << 1;
        while (blockIndex < topIndex) {
            switch (this.states[blockIndex].getBlockId()) {
                case 210: {
                    removeDeny = true;
                    removeAllow = false;
                    break;
                }
                case 211: {
                    removeDeny = false;
                    removeAllow = true;
                    break;
                }
            }
            if (removeDeny) {
                this.denyStates.clear(flagIndex);
            }
            if (removeAllow) {
                this.denyStates.clear(flagIndex + 1);
            }
            ++blockIndex;
            flagIndex += 2;
        }
    }

    private byte computeFlags(byte newFlags, BlockState ... states) {
        for (BlockState state : states) {
            int blockId = state.getBlockId();
            if ((blockId & 0xFF00) != 0) {
                newFlags = (byte)(newFlags | 3);
            } else if (blockId != 0) {
                newFlags = (byte)(newFlags | 1);
            }
            int bitSize = state.getBitSize();
            if (bitSize > 16) {
                newFlags = (byte)(newFlags | 0x1D);
            } else if (bitSize > 8) {
                newFlags = (byte)(newFlags | 0xD);
            } else if (bitSize > 4) {
                newFlags = (byte)(newFlags | 5);
            } else if (bitSize > 1 || blockId != 0) {
                newFlags = (byte)(newFlags | 1);
            }
            if (newFlags != 63) continue;
            return newFlags;
        }
        return newFlags;
    }

    @Since(value="1.4.0.0-PN")
    @PowerNukkitOnly
    public BlockStorage copy() {
        BitSet deny = this.denyStates;
        return new BlockStorage((BlockState[])this.states.clone(), this.flags, this.palette.copy(), (BitSet)(deny != null ? deny.clone() : null));
    }

    @Nonnull
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public ImmutableBlockStorage immutableCopy() {
        return new ImmutableBlockStorage(this.states, this.flags, this.palette, this.denyStates);
    }

    private boolean getFlag(byte flag) {
        return (this.flags & flag) == flag;
    }

    private void setFlag(byte flag, boolean value) {
        this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
    }

    public boolean hasBlockIds() {
        return this.getFlag((byte)1);
    }

    public boolean hasBlockIdExtras() {
        return this.getFlag((byte)2);
    }

    public boolean hasBlockDataExtras() {
        return this.getFlag((byte)4);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean hasBlockDataBig() {
        return this.getFlag((byte)8);
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public boolean hasBlockDataHuge() {
        return this.getFlag((byte)16);
    }

    private boolean isPaletteUpdated() {
        return this.getFlag((byte)32);
    }

    public void writeTo(BinaryStream stream) {
        if (!this.isPaletteUpdated()) {
            for (int i = 0; i < this.states.length; ++i) {
                this.palette.setBlock(i, this.states[i].getRuntimeId());
            }
            this.setFlag((byte)32, true);
        }
        this.palette.writeTo(stream);
    }

    public void iterateStates(BlockPositionDataConsumer<BlockState> consumer) {
        for (int i = 0; i < this.states.length; ++i) {
            int x = i >> 8 & 0xF;
            int z = i >> 4 & 0xF;
            int y = i & 0xF;
            consumer.accept(x, y, z, this.states[i]);
        }
    }

    public int getBlockChangeStateAbove(int x, int y, int z) {
        BitSet denyFlags = this.denyStates;
        if (denyFlags == null) {
            return 0;
        }
        int index = BlockStorage.getIndex(x, y, z) << 1;
        return (denyFlags.get(index) ? 1 : 0) | (denyFlags.get(index + 1) ? 2 : 0);
    }

    static {
        Arrays.fill(EMPTY, BlockState.AIR);
    }
}

