/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.level.format.updater;

import cn.nukkit.Server;
import cn.nukkit.api.PowerNukkitOnly;
import cn.nukkit.api.Since;
import cn.nukkit.blockstate.BlockState;
import cn.nukkit.level.Level;
import cn.nukkit.level.format.ChunkSection;
import cn.nukkit.level.format.generic.BaseChunk;
import cn.nukkit.level.format.updater.BeehiveUpdater;
import cn.nukkit.level.format.updater.DoorUpdater;
import cn.nukkit.level.format.updater.GroupedUpdaters;
import cn.nukkit.level.format.updater.MesaBiomeUpdater;
import cn.nukkit.level.format.updater.NewLeafUpdater;
import cn.nukkit.level.format.updater.OldWoodBarkUpdater;
import cn.nukkit.level.format.updater.SnowLayerUpdater;
import cn.nukkit.level.format.updater.StemUpdater;
import cn.nukkit.level.format.updater.Updater;
import cn.nukkit.level.format.updater.WallUpdater;

@PowerNukkitOnly
@Since(value="1.3.0.0-PN")
public final class ChunkUpdater {
    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static int getCurrentContentVersion() {
        return 10;
    }

    @PowerNukkitOnly
    @Since(value="1.4.0.0-PN")
    public static void backwardCompatibilityUpdate(Level level, BaseChunk chunk) {
        boolean updated = false;
        for (ChunkSection section : chunk.getSections()) {
            if (section.getContentVersion() >= ChunkUpdater.getCurrentContentVersion()) continue;
            if (section.getContentVersion() < 5) {
                updated = ChunkUpdater.updateToV8FromV0toV5(level, chunk, updated, section, section.getContentVersion());
            } else if (section.getContentVersion() == 5 || section.getContentVersion() == 7) {
                updated = ChunkUpdater.updateBeehiveFromV5or6or7toV8(chunk, updated, section, false);
            } else if (section.getContentVersion() == 6) {
                updated = ChunkUpdater.updateBeehiveFromV5or6or7toV8(chunk, updated, section, true);
            }
            if (section.getContentVersion() == 8) {
                updated = ChunkUpdater.upgradeWallsFromV8toV9(level, chunk, updated, section);
            }
            if (section.getContentVersion() != 9) continue;
            updated = ChunkUpdater.upgradeSnowLayersFromV9toV10(level, chunk, updated, section);
        }
        if (updated) {
            chunk.setChanged();
        }
    }

    private static boolean upgradeWallsFromV8toV9(Level level, BaseChunk chunk, boolean updated, ChunkSection section) {
        updated = ChunkUpdater.walk(chunk, section, new WallUpdater(level, section)) || updated;
        section.setContentVersion(9);
        return updated;
    }

    private static boolean upgradeSnowLayersFromV9toV10(Level level, BaseChunk chunk, boolean updated, ChunkSection section) {
        Updater[] updaterArray = new Updater[]{new NewLeafUpdater(section), new SnowLayerUpdater(level, section)};
        section.setContentVersion(10);
        return updated |= ChunkUpdater.walk(chunk, section, new GroupedUpdaters(updaterArray));
    }

    private static boolean updateBeehiveFromV5or6or7toV8(BaseChunk chunk, boolean updated, ChunkSection section, boolean updateDirection) {
        if (ChunkUpdater.walk(chunk, section, new BeehiveUpdater(section, updateDirection))) {
            updated = true;
        }
        section.setContentVersion(8);
        return updated;
    }

    private static boolean updateToV8FromV0toV5(Level level, BaseChunk chunk, boolean updated, ChunkSection section, int contentVersion) {
        WallUpdater wallUpdater = new WallUpdater(level, section);
        boolean sectionUpdated = ChunkUpdater.walk(chunk, section, new GroupedUpdaters(new MesaBiomeUpdater(section), new NewLeafUpdater(section), new BeehiveUpdater(section, true), wallUpdater, contentVersion < 1 ? new StemUpdater(level, section, 105, 103) : null, contentVersion < 1 ? new StemUpdater(level, section, 104, 86) : null, contentVersion < 5 ? new OldWoodBarkUpdater(section, 17, 0) : null, contentVersion < 5 ? new OldWoodBarkUpdater(section, 162, 4) : null, contentVersion < 5 ? new DoorUpdater(chunk, section) : null));
        updated = updated || sectionUpdated;
        int attempts = 0;
        while (sectionUpdated) {
            if (attempts++ >= 5) {
                int x = chunk.getX() << 4 | 6;
                int y = section.getY() << 4 | 6;
                int z = chunk.getZ() << 4 | 6;
                Server.getInstance().getLogger().warning("The chunk section at x:" + x + ", y:" + y + ", z:" + z + " failed to complete the backward compatibility update 1 after " + attempts + " attempts");
                break;
            }
            sectionUpdated = ChunkUpdater.walk(chunk, section, wallUpdater);
        }
        section.setContentVersion(8);
        return updated;
    }

    private static boolean walk(BaseChunk chunk, ChunkSection section, Updater updater) {
        int offsetX = chunk.getX() << 4;
        int offsetZ = chunk.getZ() << 4;
        int offsetY = section.getY() << 4;
        boolean updated = false;
        for (int x = 0; x <= 15; ++x) {
            for (int z = 0; z <= 15; ++z) {
                for (int y = 0; y <= 15; ++y) {
                    BlockState state = section.getBlockState(x, y, z, 0);
                    updated |= updater.update(offsetX, offsetY, offsetZ, x, y, z, state);
                }
            }
        }
        return updated;
    }

    private ChunkUpdater() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

